/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlApp;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCruiseControlMain {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCruiseControlMain.class);

    private KafkaCruiseControlMain() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException(String.format("USAGE: java %s cruisecontrol.properties [port] [ipaddress|hostname]", KafkaCruiseControlMain.class.getSimpleName()));
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOG.error("Uncaught exception on thread {}", (Object)t, (Object)e));
        KafkaCruiseControlConfig config = KafkaCruiseControlUtils.readConfig(args[0]);
        Integer port = KafkaCruiseControlMain.parsePort(args, config);
        String hostname = KafkaCruiseControlMain.parseHostname(args, config);
        KafkaCruiseControlApp app = new KafkaCruiseControlApp(config, port, hostname);
        app.registerShutdownHook();
        app.start();
    }

    private static Integer parsePort(String[] args, KafkaCruiseControlConfig config) {
        if (args.length > 1) {
            return Integer.parseInt(args[1]);
        }
        return config.getInt("webserver.http.port");
    }

    private static String parseHostname(String[] args, KafkaCruiseControlConfig config) {
        if (args.length > 2) {
            return args[2];
        }
        return config.getString("webserver.http.address");
    }
}

