/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.linkedin.kafka.cruisecontrol.async.AsyncKafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.KafkaCruiseControlServlet;
import com.linkedin.kafka.cruisecontrol.servlet.security.CruiseControlSecurityHandler;
import com.linkedin.kafka.cruisecontrol.servlet.security.SecurityProvider;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class KafkaCruiseControlApp {
    private static final String METRIC_DOMAIN = "kafka.cruisecontrol";
    private final Server _server;
    private final KafkaCruiseControlConfig _config;
    private final AsyncKafkaCruiseControl _kafkaCruiseControl;
    private final JmxReporter _jmxReporter;

    KafkaCruiseControlApp(KafkaCruiseControlConfig config, Integer port, String hostname) throws ServletException {
        this._config = config;
        MetricRegistry metricRegistry = new MetricRegistry();
        this._jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain(METRIC_DOMAIN).build();
        this._jmxReporter.start();
        this._kafkaCruiseControl = new AsyncKafkaCruiseControl(config, metricRegistry);
        this._server = new Server();
        NCSARequestLog requestLog = this.createRequestLog();
        if (requestLog != null) {
            this._server.setRequestLog((RequestLog)requestLog);
        }
        this._server.setConnectors(new Connector[]{this.setupHttpConnector(hostname, port)});
        ServletContextHandler contextHandler = this.createContextHandler();
        this.maybeSetSecurityHandler(contextHandler);
        this._server.setHandler((Handler)contextHandler);
        this.setupWebUi(contextHandler);
        KafkaCruiseControlServlet servlet = new KafkaCruiseControlServlet(this._kafkaCruiseControl, metricRegistry);
        String apiUrlPrefix = config.getString("webserver.api.urlprefix");
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        contextHandler.addServlet(servletHolder, apiUrlPrefix);
    }

    void start() throws Exception {
        this._kafkaCruiseControl.startUp();
        this._server.start();
        this.printStartupInfo();
    }

    void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    void stop() {
        this._kafkaCruiseControl.shutdown();
        this._jmxReporter.close();
    }

    public String serverUrl() {
        return this._server.getURI().toString();
    }

    private void printStartupInfo() {
        boolean corsEnabled = this._config.getBoolean("webserver.http.cors.enabled");
        String webApiUrlPrefix = this._config.getString("webserver.api.urlprefix");
        String uiUrlPrefix = this._config.getString("webserver.ui.urlprefix");
        String webDir = this._config.getString("webserver.ui.diskpath");
        String sessionPath = this._config.getString("webserver.session.path");
        System.out.println(">> ********************************************* <<");
        System.out.println(">> Application directory            : " + System.getProperty("user.dir"));
        System.out.println(">> REST API available on            : " + webApiUrlPrefix);
        System.out.println(">> Web UI available on              : " + uiUrlPrefix);
        System.out.println(">> Web UI Directory                 : " + webDir);
        System.out.println(">> Cookie prefix path               : " + sessionPath);
        System.out.println(">> Kafka Cruise Control started on  : " + this.serverUrl());
        System.out.println(">> CORS Enabled ?                   : " + corsEnabled);
        System.out.println(">> ********************************************* <<");
    }

    private ServerConnector setupHttpConnector(String hostname, int port) {
        ServerConnector serverConnector;
        Boolean webserverSslEnable = this._config.getBoolean("webserver.ssl.enable");
        if (webserverSslEnable != null && webserverSslEnable.booleanValue()) {
            SslContextFactory.Server sslServerContextFactory = new SslContextFactory.Server();
            sslServerContextFactory.setKeyStorePath(this._config.getString("webserver.ssl.keystore.location"));
            sslServerContextFactory.setKeyStorePassword(this._config.getPassword("webserver.ssl.keystore.password").value());
            sslServerContextFactory.setKeyManagerPassword(this._config.getPassword("webserver.ssl.key.password").value());
            sslServerContextFactory.setProtocol(this._config.getString("webserver.ssl.protocol"));
            String keyStoreType = this._config.getString("webserver.ssl.keystore.type");
            if (keyStoreType != null) {
                sslServerContextFactory.setKeyStoreType(keyStoreType);
            }
            serverConnector = new ServerConnector(this._server, (SslContextFactory)sslServerContextFactory);
        } else {
            serverConnector = new ServerConnector(this._server);
        }
        serverConnector.setHost(hostname);
        serverConnector.setPort(port);
        return serverConnector;
    }

    private void setupWebUi(ServletContextHandler contextHandler) {
        String webuiDir = this._config.getString("webserver.ui.diskpath");
        String webuiPathPrefix = this._config.getString("webserver.ui.urlprefix");
        DefaultServlet defaultServlet = new DefaultServlet();
        ServletHolder holderWebapp = new ServletHolder("default", (Servlet)defaultServlet);
        holderWebapp.setInitParameter("resourceBase", webuiDir);
        contextHandler.addServlet(holderWebapp, webuiPathPrefix);
    }

    private NCSARequestLog createRequestLog() {
        boolean accessLogEnabled = this._config.getBoolean("webserver.accesslog.enabled");
        if (accessLogEnabled) {
            String accessLogPath = this._config.getString("webserver.accesslog.path");
            int accessLogRetention = this._config.getInt("webserver.accesslog.retention.days");
            NCSARequestLog requestLog = new NCSARequestLog(accessLogPath);
            requestLog.setRetainDays(accessLogRetention);
            requestLog.setLogLatency(true);
            requestLog.setAppend(true);
            requestLog.setExtended(false);
            requestLog.setPreferProxiedForAddress(true);
            return requestLog;
        }
        return null;
    }

    private ServletContextHandler createContextHandler() {
        String sessionPath = this._config.getString("webserver.session.path");
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(sessionPath);
        return context;
    }

    private void maybeSetSecurityHandler(ServletContextHandler contextHandler) throws ServletException {
        SecurityProvider securityProvider = null;
        if (this._config.getBoolean("webserver.security.enable").booleanValue()) {
            securityProvider = this._config.getConfiguredInstance("webserver.security.provider", SecurityProvider.class);
        }
        if (securityProvider != null) {
            securityProvider.init(this._config);
            CruiseControlSecurityHandler securityHandler = new CruiseControlSecurityHandler();
            securityHandler.setConstraintMappings(securityProvider.constraintMappings());
            securityHandler.setAuthenticator(securityProvider.authenticator());
            securityHandler.setLoginService(securityProvider.loginService());
            securityHandler.setRoles(securityProvider.roles());
            contextHandler.setSecurityHandler((SecurityHandler)securityHandler);
        }
    }
}

