/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WindowState<G, E extends Entity<G>>
extends LongGenerationed {
    private final Set<E> _validEntities = new HashSet();
    private final Set<E> _extrapolatedEntities = new HashSet();

    public WindowState(long generation) {
        super(generation);
    }

    void addValidEntities(E entity) {
        this._validEntities.add(entity);
    }

    void addExtrapolatedEntities(E entity) {
        this._extrapolatedEntities.add(entity);
    }

    void maybeInclude(long windowIndex, MetricSampleCompleteness<G, E> completeness, Map<E, Integer> includedEntityExtrapolations, AggregationOptions<G, E> options) {
        HashSet<Entity> validEntitiesForWindow = new HashSet<Entity>();
        HashSet validGroupsForWindow = new HashSet();
        this.fillInValidRatios(windowIndex, completeness, includedEntityExtrapolations, options, validEntitiesForWindow, validGroupsForWindow);
        if (options.granularity() == AggregationOptions.Granularity.ENTITY_GROUP) {
            validEntitiesForWindow.removeIf(e -> !validGroupsForWindow.contains(e.group()));
        }
        if (this.meetValidEntityRatioAfterMerge(completeness, validEntitiesForWindow, options) && this.meetValidEntityGroupRatioAfterMerge(completeness, validGroupsForWindow, options)) {
            completeness.retainAllValidEntities(validEntitiesForWindow);
            completeness.retainAllValidEntityGroups(validGroupsForWindow);
            completeness.addValidWindowIndex(windowIndex);
            validEntitiesForWindow.forEach(entity -> {
                if (this._extrapolatedEntities.contains(entity)) {
                    includedEntityExtrapolations.compute(entity, (e, c) -> c == null ? 1 : c + 1);
                }
            });
        }
    }

    private boolean meetValidEntityRatioAfterMerge(MetricSampleCompleteness<G, E> completeness, Set<E> validEntitiesForWindow, AggregationOptions<G, E> options) {
        int totalNumEntities = options.interestedEntities().size();
        int numValidEntitiesAfterMerge = this.numValidElementsAfterMerge(completeness.validEntities(), validEntitiesForWindow);
        return numValidEntitiesAfterMerge > 0 && (double)((float)numValidEntitiesAfterMerge / (float)totalNumEntities) >= options.minValidEntityRatio();
    }

    private boolean meetValidEntityGroupRatioAfterMerge(MetricSampleCompleteness<G, E> completeness, Set<G> validEntityGroupForWindow, AggregationOptions<G, E> options) {
        int totalNumEntityGroups = options.interestedEntityGroups().size();
        int numValidEntityGroupsAfterMerge = this.numValidElementsAfterMerge(completeness.validEntityGroups(), validEntityGroupForWindow);
        return numValidEntityGroupsAfterMerge > 0 && (double)((float)numValidEntityGroupsAfterMerge / (float)totalNumEntityGroups) >= options.minValidEntityGroupRatio();
    }

    private void fillInValidRatios(long windowIndex, MetricSampleCompleteness<G, E> completeness, Map<E, Integer> includedExtrapolationsByEntity, AggregationOptions<G, E> options, Set<E> validEntitiesForOption, Set<G> validGroupsForOption) {
        int numExtrapolatedEntitiesForWindow = 0;
        HashMap<Object, Integer> numValidEntitiesByGroupForOption = new HashMap<Object, Integer>();
        HashSet invalidGroupsForOption = new HashSet();
        for (Object entity : options.interestedEntities()) {
            if (this._validEntities.contains(entity)) {
                int includedExtrapolations;
                int extrapolationAddition = 0;
                if (this._extrapolatedEntities.contains(entity)) {
                    ++numExtrapolatedEntitiesForWindow;
                    extrapolationAddition = 1;
                }
                if ((includedExtrapolations = includedExtrapolationsByEntity.getOrDefault(entity, 0).intValue()) + extrapolationAddition <= options.maxAllowedExtrapolationsPerEntity()) {
                    validEntitiesForOption.add(entity);
                    numValidEntitiesByGroupForOption.compute(((Entity)entity).group(), (g, v) -> v == null ? 1 : v + 1);
                    continue;
                }
                invalidGroupsForOption.add(((Entity)entity).group());
                continue;
            }
            invalidGroupsForOption.add(((Entity)entity).group());
        }
        int validEntitiesWithGroupGranularity = validEntitiesForOption.size();
        for (Object group : invalidGroupsForOption) {
            Integer count = (Integer)numValidEntitiesByGroupForOption.remove(group);
            if (count == null) continue;
            validEntitiesWithGroupGranularity -= count.intValue();
        }
        validGroupsForOption.addAll(numValidEntitiesByGroupForOption.keySet());
        int totalNumEntities = options.interestedEntities().size();
        completeness.addValidEntityRatio(windowIndex, (float)validEntitiesForOption.size() / (float)totalNumEntities);
        completeness.addValidEntityRatioWithGroupGranularity(windowIndex, (float)validEntitiesWithGroupGranularity / (float)totalNumEntities);
        completeness.addExtrapolationEntityRatio(windowIndex, (float)numExtrapolatedEntitiesForWindow / (float)totalNumEntities);
        completeness.addValidEntityGroupRatio(windowIndex, (float)numValidEntitiesByGroupForOption.size() / (float)options.interestedEntityGroups().size());
    }

    private int numValidElementsAfterMerge(Set<?> validElements, Set<?> validElementsToMerge) {
        int numValidElements = 0;
        for (Object entity : validElements) {
            if (!validElementsToMerge.contains(entity)) continue;
            ++numValidElements;
        }
        return numValidElements;
    }

    private boolean canExtrapolate(E entity, Map<E, Integer> includedEntityExtrapolations, AggregationOptions<G, E> options) {
        int additionalExtrapolation = this._extrapolatedEntities.contains(entity) ? 1 : 0;
        int includedExtrapolations = includedEntityExtrapolations.getOrDefault(entity, 0);
        return includedExtrapolations + additionalExtrapolation <= options.maxAllowedExtrapolationsPerEntity();
    }
}

