/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.WindowIndexedArrays;
import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.Extrapolation;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMetricValues
extends WindowIndexedArrays {
    private static final Logger LOG = LoggerFactory.getLogger(RawMetricValues.class);
    private final byte _minSamplesPerWindow;
    private final byte _halfMinRequiredSamples;
    private final Map<Short, float[]> _windowValuesByMetricId;
    private final byte[] _counts;
    private final BitSet _extrapolations;
    private final BitSet _validity;

    @Override
    protected int length() {
        return this._counts.length;
    }

    public RawMetricValues(int numWindowsToKeep, byte minSamplesPerWindow, int numMetricTypesInSample) {
        if (numWindowsToKeep <= 1) {
            throw new IllegalArgumentException("The number of windows should be at least 2 because at least one available window and one current window are needed.");
        }
        this._windowValuesByMetricId = new HashMap<Short, float[]>(numMetricTypesInSample);
        this._counts = new byte[numWindowsToKeep];
        this._extrapolations = new BitSet(numWindowsToKeep);
        this._validity = new BitSet(numWindowsToKeep);
        this._minSamplesPerWindow = minSamplesPerWindow;
        this._halfMinRequiredSamples = (byte)Math.max(1, this._minSamplesPerWindow / 2);
        this._oldestWindowIndex = Long.MAX_VALUE;
    }

    private void maybeUpdateValidityAndExtrapolationOfPrevAndNextFor(int arrayIndex) {
        if (this._counts[arrayIndex] >= this._minSamplesPerWindow) {
            int nextArrayIndex;
            int prevArrayIndex;
            if (arrayIndex != this.arrayIndex(this.currentWindowIndex()) && this.hasTwoLeftNeighbours(arrayIndex) && this._counts[prevArrayIndex = this.prevArrayIndex(arrayIndex)] == 0) {
                this.updateAvgAdjacent(prevArrayIndex);
            }
            if (this.hasTwoRightNeighbours(arrayIndex) && this._counts[nextArrayIndex = this.nextArrayIndex(arrayIndex)] == 0) {
                this.updateAvgAdjacent(nextArrayIndex);
            }
        }
    }

    private int updateWindowValueAndCount(MetricSample<?, ?> sample, long windowIndex, MetricDef metricDef) {
        int arrayIndex = this.arrayIndex(windowIndex);
        for (Map.Entry<Short, Double> entry : sample.allMetricValues().entrySet()) {
            this._windowValuesByMetricId.computeIfAbsent(entry.getKey(), k -> new float[this._counts.length]);
            this.updateWindowValueForMetric(entry.getValue(), metricDef.metricInfo(entry.getKey()), arrayIndex);
        }
        int n = arrayIndex;
        this._counts[n] = (byte)(this._counts[n] + 1);
        return arrayIndex;
    }

    public synchronized void addSample(MetricSample<?, ?> sample, long windowIndex, MetricDef metricDef) {
        if (windowIndex < this._oldestWindowIndex) {
            return;
        }
        if (windowIndex > this.currentWindowIndex()) {
            throw new IllegalArgumentException("Cannot add sample to window index " + windowIndex + ", which is larger than the current window index " + this.currentWindowIndex());
        }
        int arrayIndex = this.updateWindowValueAndCount(sample, windowIndex, metricDef);
        this.maybeUpdateValidityAndExtrapolationFor(arrayIndex);
        this.maybeUpdateValidityAndExtrapolationOfPrevAndNextFor(arrayIndex);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Added metric sample {} to window index {}, array index is {}, current count : {}", new Object[]{sample, windowIndex, arrayIndex, this._counts[arrayIndex]});
        }
    }

    @Override
    public synchronized void updateOldestWindowIndex(long newOldestWindowIndex) {
        long prevLastWindowIndex = this.lastWindowIndex();
        this._oldestWindowIndex = newOldestWindowIndex;
        if (prevLastWindowIndex >= this._oldestWindowIndex) {
            this.maybeUpdateValidityAndExtrapolationFor(this.arrayIndex(prevLastWindowIndex));
        }
    }

    public synchronized boolean isValid(int maxAllowedWindowsWithExtrapolation) {
        int currentArrayIndex = this.arrayIndex(this.currentWindowIndex());
        int numValidIndicesAdjustment = this._validity.get(currentArrayIndex) ? 1 : 0;
        boolean allIndicesValid = this._validity.cardinality() - numValidIndicesAdjustment == this._counts.length - 1;
        return allIndicesValid && this.numWindowsWithExtrapolation() <= maxAllowedWindowsWithExtrapolation;
    }

    public synchronized int numWindowsWithExtrapolation() {
        int currentArrayIndex = this.arrayIndex(this.currentWindowIndex());
        int numExtrapolationAdjustment = this._extrapolations.get(currentArrayIndex) ? 1 : 0;
        return this._extrapolations.cardinality() - numExtrapolationAdjustment;
    }

    public synchronized boolean isValidAtWindowIndex(long windowIndex) {
        return this._validity.get(this.arrayIndex(windowIndex));
    }

    public synchronized boolean isExtrapolatedAtWindowIndex(long windowIndex) {
        return this._extrapolations.get(this.arrayIndex(windowIndex));
    }

    public synchronized byte sampleCountsAtWindowIndex(long windowIndex) {
        return this._counts[this.arrayIndex(windowIndex)];
    }

    public synchronized void sanityCheckWindowIndex(long windowIndex) {
        this.validateWindowIndex(windowIndex);
    }

    public synchronized void sanityCheckWindowRangeReset(long startingWindowIndex, int numWindowIndicesToReset) {
        if (this.inValidWindowRange(startingWindowIndex) || this.inValidWindowRange(startingWindowIndex + (long)numWindowIndicesToReset - 1L)) {
            throw new IllegalStateException("Should never reset a window index that is in the valid range");
        }
    }

    public synchronized int resetWindowIndices(long startingWindowIndex, int numWindowIndicesToReset) {
        int numAbandonedSamples = 0;
        for (long i = startingWindowIndex; i < startingWindowIndex + (long)numWindowIndicesToReset; ++i) {
            int arrayIndex = this.arrayIndex(i);
            numAbandonedSamples += this._counts[arrayIndex];
            this._counts[arrayIndex] = 0;
            this.resetValidityAndExtrapolation(arrayIndex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resetting window index [{}, {}], abandon {} samples.", new Object[]{startingWindowIndex, startingWindowIndex + (long)numWindowIndicesToReset - 1L, numAbandonedSamples});
        }
        return numAbandonedSamples;
    }

    public synchronized ValuesAndExtrapolations aggregate(SortedSet<Long> windowIndices, MetricDef metricDef) {
        return this.aggregate(windowIndices, metricDef, true);
    }

    public synchronized ValuesAndExtrapolations peekCurrentWindow(long currentWindowIndex, MetricDef metricDef) {
        TreeSet<Long> window = new TreeSet<Long>();
        window.add(currentWindowIndex);
        return this.aggregate(window, metricDef, false);
    }

    private ValuesAndExtrapolations aggregate(SortedSet<Long> windowIndices, MetricDef metricDef, boolean checkWindow) {
        if (this._windowValuesByMetricId.isEmpty()) {
            return ValuesAndExtrapolations.empty(windowIndices.size(), metricDef);
        }
        HashMap<Short, MetricValues> aggValues = new HashMap<Short, MetricValues>(this._windowValuesByMetricId.size());
        TreeMap<Integer, Extrapolation> extrapolations = new TreeMap<Integer, Extrapolation>();
        for (Map.Entry<Short, float[]> entry : this._windowValuesByMetricId.entrySet()) {
            short metricId = entry.getKey();
            float[] values = entry.getValue();
            MetricInfo info = metricDef.metricInfo(metricId);
            MetricValues aggValuesForMetric = new MetricValues(windowIndices.size());
            aggValues.put(metricId, aggValuesForMetric);
            int resultIndex = 0;
            Iterator iterator = windowIndices.iterator();
            while (iterator.hasNext()) {
                int arrayIndex;
                long windowIndex = (Long)iterator.next();
                if (checkWindow) {
                    this.validateWindowIndex(windowIndex);
                }
                if (this._counts[arrayIndex = this.arrayIndex(windowIndex)] >= this._halfMinRequiredSamples) {
                    aggValuesForMetric.set(resultIndex, this.getValue(info, arrayIndex, values));
                    if (this._counts[arrayIndex] < this._minSamplesPerWindow) {
                        extrapolations.putIfAbsent(resultIndex, Extrapolation.AVG_AVAILABLE);
                    }
                } else if (arrayIndex != this.firstArrayIndex() && arrayIndex != this.lastArrayIndex() && this._counts[this.prevArrayIndex(arrayIndex)] >= this._minSamplesPerWindow && this._counts[this.nextArrayIndex(arrayIndex)] >= this._minSamplesPerWindow) {
                    extrapolations.putIfAbsent(resultIndex, Extrapolation.AVG_ADJACENT);
                    int prevArrayIndex = this.prevArrayIndex(arrayIndex);
                    int nextArrayIndex = this.nextArrayIndex(arrayIndex);
                    double total = this._windowValuesByMetricId.get(metricId)[prevArrayIndex] + (this._counts[arrayIndex] == 0 ? 0.0f : this._windowValuesByMetricId.get(metricId)[arrayIndex]) + this._windowValuesByMetricId.get(metricId)[nextArrayIndex];
                    switch (info.aggregationFunction()) {
                        case AVG: {
                            aggValuesForMetric.set(resultIndex, total / (double)(this._counts[prevArrayIndex] + this._counts[arrayIndex] + this._counts[nextArrayIndex]));
                            break;
                        }
                        case MAX: 
                        case LATEST: {
                            aggValuesForMetric.set(resultIndex, total / (double)(this._counts[arrayIndex] > 0 ? 3 : 2));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Should never be here.");
                        }
                    }
                } else if (this._counts[arrayIndex] > 0) {
                    aggValuesForMetric.set(resultIndex, this.getValue(info, arrayIndex, values));
                    extrapolations.putIfAbsent(resultIndex, Extrapolation.FORCED_INSUFFICIENT);
                } else {
                    aggValuesForMetric.set(resultIndex, 0.0);
                    extrapolations.putIfAbsent(resultIndex, Extrapolation.NO_VALID_EXTRAPOLATION);
                }
                ++resultIndex;
            }
        }
        return new ValuesAndExtrapolations(new AggregatedMetricValues(aggValues), extrapolations);
    }

    public synchronized int numSamples() {
        int count = 0;
        for (byte i : this._counts) {
            count += i;
        }
        return count;
    }

    private float getValue(MetricInfo info, int index, float[] values) {
        if (this._counts[index] == 0) {
            return 0.0f;
        }
        switch (info.aggregationFunction()) {
            case AVG: {
                return values[index] / (float)this._counts[index];
            }
            case MAX: 
            case LATEST: {
                return values[index];
            }
        }
        throw new IllegalStateException("Should never be here.");
    }

    private void updateWindowValueForMetric(double newValue, MetricInfo info, int arrayIndex) {
        switch (info.aggregationFunction()) {
            case AVG: {
                this.add(newValue, info.id(), arrayIndex);
                break;
            }
            case MAX: {
                this.max(newValue, info.id(), arrayIndex);
                break;
            }
            case LATEST: {
                this.latest(newValue, info.id(), arrayIndex);
                break;
            }
            default: {
                throw new IllegalStateException("Should never be here");
            }
        }
    }

    private void add(double newValue, short metricId, int index) {
        this._windowValuesByMetricId.get((Object)Short.valueOf((short)metricId))[index] = (float)(this._counts[index] == 0 ? newValue : (double)this._windowValuesByMetricId.get(metricId)[index] + newValue);
    }

    private void max(double newValue, short metricId, int index) {
        this._windowValuesByMetricId.get((Object)Short.valueOf((short)metricId))[index] = (float)(this._counts[index] == 0 ? newValue : Math.max((double)this._windowValuesByMetricId.get(metricId)[index], newValue));
    }

    private void latest(double newValue, short metricId, int index) {
        this._windowValuesByMetricId.get((Object)Short.valueOf((short)metricId))[index] = (float)newValue;
    }

    private void maybeUpdateValidityAndExtrapolationFor(int arrayIndex) {
        if (!(this.updateEnoughSamples(arrayIndex) || this._extrapolations.get(arrayIndex) || this.updateForcedInsufficient(arrayIndex) || this.updateAvgAdjacent(arrayIndex))) {
            this.resetValidityAndExtrapolation(arrayIndex);
        }
    }

    private void resetValidityAndExtrapolation(int arrayIndex) {
        this._validity.clear(arrayIndex);
        this._extrapolations.clear(arrayIndex);
    }

    private boolean updateEnoughSamples(int arrayIndex) {
        if (this._counts[arrayIndex] == this._minSamplesPerWindow) {
            this._validity.set(arrayIndex);
            this._extrapolations.clear(arrayIndex);
            return true;
        }
        return this._counts[arrayIndex] >= this._minSamplesPerWindow;
    }

    private boolean updateAvgAdjacent(int arrayIndex) {
        int prevArrayIndex = this.prevArrayIndex(arrayIndex);
        int nextArrayIndex = this.nextArrayIndex(arrayIndex);
        if (prevArrayIndex == -1 || nextArrayIndex == -1) {
            return false;
        }
        if (this._counts[prevArrayIndex] >= this._minSamplesPerWindow && this._counts[nextArrayIndex] >= this._minSamplesPerWindow) {
            this._validity.set(arrayIndex);
            this._extrapolations.set(arrayIndex);
            return true;
        }
        return false;
    }

    private boolean updateForcedInsufficient(int arrayIndex) {
        if (this._counts[arrayIndex] > 0) {
            this._validity.set(arrayIndex);
            this._extrapolations.set(arrayIndex);
            return true;
        }
        return false;
    }

    private boolean hasTwoLeftNeighbours(int arrayIndex) {
        int prevIdx = this.prevArrayIndex(arrayIndex);
        return prevIdx != -1 && this.prevArrayIndex(prevIdx) != -1;
    }

    private boolean hasTwoRightNeighbours(int arrayIndex) {
        int nextIdx = this.nextArrayIndex(arrayIndex);
        return nextIdx != -1 && this.nextArrayIndex(nextIdx) != -1;
    }
}

