/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringJoiner;

public class MetricValues {
    private final float[] _values;
    private float _max;
    private double _sumForAvg;

    public MetricValues(int numWindows) {
        this._values = new float[numWindows];
        this._sumForAvg = 0.0;
        this._max = Float.MIN_VALUE;
    }

    public void set(int index, double value) {
        if (this._max == this._values[index] && value < (double)this._max) {
            this._max = Float.MIN_VALUE;
        }
        this._sumForAvg += value - (double)this._values[index];
        this._values[index] = (float)value;
    }

    public double get(int index) {
        return this._values[index];
    }

    public void clear() {
        Arrays.fill(this._values, 0.0f);
        this._sumForAvg = 0.0;
        this._max = Float.MIN_VALUE;
    }

    public int length() {
        return this._values.length;
    }

    public void add(double[] values) {
        if (values.length != this._values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be added to the MetricValue with length %d", values.length, this._values.length));
        }
        this._max = Float.MIN_VALUE;
        for (int i = 0; i < this._values.length; ++i) {
            double toAdd = values[i];
            int n = i;
            this._values[n] = (float)((double)this._values[n] + toAdd);
            this._sumForAvg += toAdd;
            this._max = Math.max(this._max, this._values[i]);
        }
    }

    public void add(MetricValues metricValues) {
        if (metricValues.length() != this._values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be added to the MetricValue with length %d", metricValues.length(), this._values.length));
        }
        this._max = Float.MIN_VALUE;
        for (int i = 0; i < this._values.length; ++i) {
            double toAdd = metricValues.get(i);
            int n = i;
            this._values[n] = (float)((double)this._values[n] + toAdd);
            this._sumForAvg += toAdd;
            this._max = Math.max(this._max, this._values[i]);
        }
    }

    public void subtract(double[] values) {
        if (values.length != this._values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be subtracted from the MetricValue with length %d", values.length, this._values.length));
        }
        this._max = Float.MIN_VALUE;
        for (int i = 0; i < this._values.length; ++i) {
            double toDeduct = values[i];
            int n = i;
            this._values[n] = (float)((double)this._values[n] - toDeduct);
            this._sumForAvg -= toDeduct;
            this._max = Math.max(this._max, this._values[i]);
        }
    }

    public void subtract(MetricValues metricValues) {
        if (metricValues.length() != this._values.length) {
            throw new IllegalArgumentException(String.format("The value array of length %d cannot be subtracted from the MetricValue with length %d", metricValues.length(), this._values.length));
        }
        this._max = Float.MIN_VALUE;
        for (int i = 0; i < this._values.length; ++i) {
            double toDeduct = metricValues.get(i);
            int n = i;
            this._values[n] = (float)((double)this._values[n] - toDeduct);
            this._sumForAvg -= toDeduct;
            this._max = Math.max(this._max, this._values[i]);
        }
    }

    public float avg() {
        return (float)(this._sumForAvg / (double)this._values.length);
    }

    public float max() {
        if (this._max >= 0.0f) {
            return this._max;
        }
        return this.updateMax();
    }

    public float latest() {
        return this._values[0];
    }

    public double[] doubleArray() {
        double[] result = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            result[i] = this._values[i];
        }
        return result;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(String.format("{avg:\"%.3f\", max:\"%.3f\", {", Float.valueOf(this.avg()), Float.valueOf(this.max())).getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < this._values.length - 1; ++i) {
            out.write((i + ":" + this._values[i] + ", ").getBytes(StandardCharsets.UTF_8));
        }
        out.write((this._values.length - 1 + ":" + this._values[this._values.length - 1] + "}}").getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (int i = 0; i < this._values.length; ++i) {
            joiner.add(i + ":" + this._values[i]);
        }
        return String.format("{avg:%f, max:%f, %s}", Float.valueOf(this.avg()), Float.valueOf(this.max()), joiner.toString());
    }

    private float updateMax() {
        this._max = this._values[0];
        for (int i = 1; i < this._values.length; ++i) {
            this._max = Math.max(this._max, this._values[i]);
        }
        return this._max;
    }
}

