/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.model.Entity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MetricSampleCompleteness<G, E extends Entity<G>>
extends LongGenerationed {
    private final SortedMap<Long, Float> _validEntityRatioByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedMap<Long, Float> _validEntityRatioWithGroupGranularityByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedMap<Long, Float> _validEntityGroupRatioByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedMap<Long, Float> _extrapolatedEntitiesByWindowIndex = new TreeMap(Collections.reverseOrder());
    private final SortedSet<Long> _validWindowIndices = new TreeSet(Collections.reverseOrder());
    private final long _windowMs;
    private final Set<E> _validEntities = new HashSet();
    private final Set<G> _validEntityGroups = new HashSet<G>();
    private float _validEntityRatio = 0.0f;
    private float _validEntityGroupRatio = 0.0f;

    public MetricSampleCompleteness(long generation, long windowMs) {
        super(generation);
        this._windowMs = windowMs;
    }

    void addValidEntityRatio(long windowIndex, float validEntityRatio) {
        this._validEntityRatioByWindowIndex.put(windowIndex, Float.valueOf(validEntityRatio));
    }

    void addValidEntityRatioWithGroupGranularity(long windowIndex, float validEntityRatio) {
        this._validEntityRatioWithGroupGranularityByWindowIndex.put(windowIndex, Float.valueOf(validEntityRatio));
    }

    void addValidEntityGroupRatio(long windowIndex, float validEntityGroupRatio) {
        this._validEntityGroupRatioByWindowIndex.put(windowIndex, Float.valueOf(validEntityGroupRatio));
    }

    void addExtrapolationEntityRatio(long windowIndex, float extrapolatedEntityRatio) {
        this._extrapolatedEntitiesByWindowIndex.put(windowIndex, Float.valueOf(extrapolatedEntityRatio));
    }

    void addValidWindowIndex(long windowIndex) {
        this._validWindowIndices.add(windowIndex);
    }

    void setValidEntityRatio(float validEntityRatio) {
        this._validEntityRatio = validEntityRatio;
    }

    void setValidEntityGroupRatio(float validEntityGroupRatio) {
        this._validEntityGroupRatio = validEntityGroupRatio;
    }

    void addValidEntities(Set<E> coveredEntities) {
        this._validEntities.addAll(coveredEntities);
    }

    void addValidEntityGroups(Set<G> coveredEntityGroups) {
        this._validEntityGroups.addAll(coveredEntityGroups);
    }

    void retainAllValidEntities(Set<E> coveredEntitiesToRetain) {
        this._validEntities.retainAll(coveredEntitiesToRetain);
    }

    void retainAllValidEntityGroups(Set<G> coveredEntityGroupsToRetain) {
        this._validEntityGroups.retainAll(coveredEntityGroupsToRetain);
    }

    public SortedMap<Long, Float> validEntityRatioByWindowIndex() {
        return this._validEntityRatioByWindowIndex;
    }

    public SortedMap<Long, Float> validEntityRatioWithGroupGranularityByWindowIndex() {
        return this._validEntityRatioWithGroupGranularityByWindowIndex;
    }

    public SortedMap<Long, Float> validEntityGroupRatioByWindowIndex() {
        return this._validEntityGroupRatioByWindowIndex;
    }

    public SortedMap<Long, Float> extrapolatedEntitiesByWindowIndex() {
        return this._extrapolatedEntitiesByWindowIndex;
    }

    public SortedSet<Long> validWindowIndices() {
        return this._validWindowIndices;
    }

    public Set<E> validEntities() {
        return this._validEntities;
    }

    public Set<G> validEntityGroups() {
        return this._validEntityGroups;
    }

    public float validEntityRatio() {
        return this._validEntityRatio;
    }

    public float validEntityGroupRatio() {
        return this._validEntityGroupRatio;
    }

    public long firstWindowIndex() {
        return this._validEntityRatioByWindowIndex.lastKey();
    }

    public long lastWindowIndex() {
        return this._validEntityRatioByWindowIndex.firstKey();
    }

    public long windowMs() {
        return this._windowMs;
    }

    @Override
    public void setGeneration(Long generation) {
        throw new RuntimeException("The generation is immutable");
    }
}

