/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.WindowIndexedArrays;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricSampleAggregatorState<G, E extends Entity<G>>
extends WindowIndexedArrays {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSampleAggregatorState.class);
    private final Map<AggregationOptions<G, E>, MetricSampleCompleteness<G, E>> _completenessCache;
    private final ConcurrentNavigableMap<Long, WindowState<G, E>> _windowStates;
    private final MyAtomicLong[] _windowGenerations;
    private final long _windowMs;

    @Override
    protected int length() {
        return this._windowGenerations.length;
    }

    MetricSampleAggregatorState(int numWindows, long windowMs, final int completenessCacheSize) {
        this._completenessCache = new LinkedHashMap<AggregationOptions<G, E>, MetricSampleCompleteness<G, E>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<AggregationOptions<G, E>, MetricSampleCompleteness<G, E>> eldest) {
                return this.size() > completenessCacheSize;
            }
        };
        this._windowStates = new ConcurrentSkipListMap(Comparator.reverseOrder());
        this._windowGenerations = new MyAtomicLong[numWindows];
        for (int arrayIndex = 0; arrayIndex < numWindows; ++arrayIndex) {
            this._windowGenerations[arrayIndex] = new MyAtomicLong(0L);
        }
        this._windowMs = windowMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWindowGeneration(long windowIndex, long generation) {
        int arrayIndex = this.arrayIndex(windowIndex);
        MyAtomicLong myAtomicLong = this._windowGenerations[arrayIndex];
        synchronized (myAtomicLong) {
            if (windowIndex >= this._oldestWindowIndex) {
                this._windowGenerations[arrayIndex].set(generation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated window {} generation to {}", (Object)(windowIndex * this._windowMs), (Object)generation);
                }
            }
        }
    }

    synchronized void updateWindowState(long windowIndex, WindowState<G, E> windowState) {
        if (windowIndex >= this._oldestWindowIndex) {
            this._windowStates.put(windowIndex, windowState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetWindowIndices(long startingWindowIndex, int numWindowIndicesToReset) {
        if (this.inValidWindowRange(startingWindowIndex) || this.inValidWindowRange(startingWindowIndex + (long)numWindowIndicesToReset - 1L)) {
            throw new IllegalStateException("Should never reset a window index that is in the valid range");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting window indices [{}, {}]", (Object)startingWindowIndex, (Object)(startingWindowIndex + (long)numWindowIndicesToReset - 1L));
        }
        for (long wi = startingWindowIndex; wi < startingWindowIndex + (long)numWindowIndicesToReset; ++wi) {
            int arrayIndex = this.arrayIndex(wi);
            MyAtomicLong myAtomicLong = this._windowGenerations[arrayIndex];
            synchronized (myAtomicLong) {
                this._windowGenerations[arrayIndex].set(0L);
                this._windowStates.remove(wi);
                continue;
            }
        }
    }

    synchronized List<Long> windowIndicesToUpdate(long oldestWindowIndex, long currentWindowIndex) {
        ArrayList<Long> windowIndicesToUpdate = new ArrayList<Long>();
        for (long windowIndex = oldestWindowIndex; windowIndex < currentWindowIndex; ++windowIndex) {
            WindowState windowState = (WindowState)this._windowStates.get(windowIndex);
            int arrayIndex = this.arrayIndex(windowIndex);
            if (windowState != null && this._windowGenerations[arrayIndex].get() <= windowState.generation()) continue;
            windowIndicesToUpdate.add(windowIndex);
        }
        while (!this._windowStates.isEmpty() && (Long)this._windowStates.lastKey() < oldestWindowIndex) {
            this._windowStates.remove(this._windowStates.lastKey());
        }
        return windowIndicesToUpdate;
    }

    synchronized MetricSampleCompleteness<G, E> completeness(long fromWindowIndex, long toWindowIndex, AggregationOptions<G, E> options, long currentGeneration) {
        MetricSampleCompleteness<G, E> completeness = this._completenessCache.get(options);
        if (completeness == null || completeness.generation() < currentGeneration || fromWindowIndex != completeness.firstWindowIndex() || toWindowIndex != completeness.lastWindowIndex()) {
            completeness = this.computeCompleteness(fromWindowIndex, toWindowIndex, options, currentGeneration);
            if (((Long)this._windowStates.lastKey()).longValue() == completeness.firstWindowIndex() && ((Long)this._windowStates.firstKey()).longValue() == completeness.lastWindowIndex()) {
                this._completenessCache.put(options, completeness);
            }
        }
        return completeness;
    }

    synchronized Map<Long, WindowState<G, E>> windowStates() {
        return this._windowStates;
    }

    synchronized Map<Long, Long> windowGenerations() {
        TreeMap<Long, Long> windowGenerations = new TreeMap<Long, Long>(Comparator.reverseOrder());
        for (long wi = this._oldestWindowIndex; wi < this.currentWindowIndex(); ++wi) {
            int arrayIndex = this.arrayIndex(wi);
            windowGenerations.put(wi, this._windowGenerations[arrayIndex].get());
        }
        return windowGenerations;
    }

    synchronized void clear() {
        this._oldestWindowIndex = 0L;
        this._completenessCache.clear();
        this._windowStates.clear();
        for (MyAtomicLong generation : this._windowGenerations) {
            generation.set(0L);
        }
    }

    private MetricSampleCompleteness<G, E> computeCompleteness(long fromWindowIndex, long toWindowIndex, AggregationOptions<G, E> options, long currentGeneration) {
        MetricSampleCompleteness<Object, Object> completeness = new MetricSampleCompleteness<Object, Object>(currentGeneration, this._windowMs);
        HashMap entityExtrapolations = new HashMap();
        completeness.addValidEntities(new HashSet<E>(options.interestedEntities()));
        completeness.addValidEntityGroups(new HashSet<G>(options.interestedEntityGroups()));
        for (Map.Entry entry : this._windowStates.entrySet()) {
            long windowIndex = (Long)entry.getKey();
            if (windowIndex > toWindowIndex) continue;
            if (windowIndex < fromWindowIndex) break;
            WindowState windowState = (WindowState)entry.getValue();
            windowState.maybeInclude(windowIndex, completeness, entityExtrapolations, options);
        }
        if (completeness.validWindowIndices().isEmpty()) {
            completeness.retainAllValidEntities(Collections.emptySet());
            completeness.retainAllValidEntityGroups(Collections.emptySet());
        }
        completeness.setValidEntityRatio((float)completeness.validEntities().size() / (float)options.interestedEntities().size());
        completeness.setValidEntityGroupRatio((float)completeness.validEntityGroups().size() / (float)options.interestedEntityGroups().size());
        return completeness;
    }

    private static class MyAtomicLong
    extends AtomicLong {
        MyAtomicLong(long initialValue) {
            super(initialValue);
        }
    }
}

