/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregatorState;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.RawMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSampleAggregator<G, E extends Entity<G>>
extends LongGenerationed {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSampleAggregator.class);
    private final ConcurrentMap<E, RawMetricValues> _rawMetrics;
    private final MetricSampleAggregatorState<G, E> _aggregatorState;
    private final ReentrantLock _windowRollingLock;
    private final ConcurrentMap<E, E> _identityEntityMap = new ConcurrentHashMap<E, E>();
    protected final int _numWindows;
    protected final byte _minSamplesPerWindow;
    protected final int _numWindowsToKeep;
    protected final long _windowMs;
    protected final long _monitoringPeriodMs;
    protected final MetricDef _metricDef;
    protected SampleType _sampleType;
    private volatile long _currentWindowIndex;
    private volatile long _oldestWindowIndex;

    public MetricSampleAggregator(int numWindows, long windowMs, byte minSamplesPerWindow, int completenessCacheSize, MetricDef metricDef) {
        super(0L);
        this._rawMetrics = new ConcurrentHashMap<E, RawMetricValues>();
        this._numWindows = numWindows;
        this._windowMs = windowMs;
        this._monitoringPeriodMs = (long)this._numWindows * this._windowMs;
        this._numWindowsToKeep = this._numWindows + 1;
        this._minSamplesPerWindow = minSamplesPerWindow;
        this._windowRollingLock = new ReentrantLock();
        this._metricDef = metricDef;
        this._aggregatorState = new MetricSampleAggregatorState(numWindows, this._windowMs, completenessCacheSize);
        this._oldestWindowIndex = 0L;
        this._currentWindowIndex = 0L;
    }

    public boolean addSample(MetricSample<G, E> sample) {
        if (!sample.isValid(this._metricDef)) {
            LOG.debug("The metric sample is discarded due to missing metrics. Sample: {}", sample);
            return false;
        }
        long windowIndex = this.windowIndex(sample.sampleTime());
        if (windowIndex < this._oldestWindowIndex) {
            return false;
        }
        boolean newWindowsRolledOut = this.maybeRollOutNewWindow(windowIndex);
        RawMetricValues rawMetricValues = this._rawMetrics.computeIfAbsent(this.identity(sample.entity()), k -> {
            this._windowRollingLock.lock();
            try {
                RawMetricValues rawValues = new RawMetricValues(this._numWindowsToKeep, this._minSamplesPerWindow, this._metricDef.size());
                rawValues.updateOldestWindowIndex(this._oldestWindowIndex);
                RawMetricValues rawMetricValues = rawValues;
                return rawMetricValues;
            }
            finally {
                this._windowRollingLock.unlock();
            }
        });
        LOG.trace("Adding sample {} to window index {}", sample, (Object)windowIndex);
        rawMetricValues.addSample(sample, windowIndex, this._metricDef);
        if (newWindowsRolledOut || windowIndex != this._currentWindowIndex) {
            this._aggregatorState.updateWindowGeneration(windowIndex, this._generation.incrementAndGet());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSampleAggregationResult<G, E> aggregate(long from, long to, AggregationOptions<G, E> options) throws NotEnoughValidWindowsException {
        this._windowRollingLock.lock();
        try {
            long fromWindowIndex = Math.max(this.windowIndex(from), this._oldestWindowIndex);
            long toWindowIndex = Math.min(this.windowIndex(to), this._currentWindowIndex - 1L);
            if (fromWindowIndex > this._currentWindowIndex || toWindowIndex < this._oldestWindowIndex) {
                throw new NotEnoughValidWindowsException(String.format("There is no window available in range [%d, %d] (index [%d, %d]). Window index (current: %d, oldest: %d).", from, to, fromWindowIndex, toWindowIndex, this._currentWindowIndex, this._oldestWindowIndex));
            }
            this.maybeUpdateAggregatorState();
            AggregationOptions<G, E> interpretedOptions = this.interpretAggregationOptions(options);
            MetricSampleCompleteness<G, E> completeness = this._aggregatorState.completeness(fromWindowIndex, toWindowIndex, interpretedOptions, this.generation());
            this.validateCompleteness(from, to, completeness, interpretedOptions);
            List<Long> windows = this.toWindows(completeness.validWindowIndices());
            MetricSampleAggregationResult<G, Entity> result = new MetricSampleAggregationResult<G, Entity>(this.generation(), completeness);
            Set<E> entitiesToInclude = interpretedOptions.includeInvalidEntities() ? interpretedOptions.interestedEntities() : completeness.validEntities();
            for (Entity entity : entitiesToInclude) {
                ValuesAndExtrapolations valuesAndExtrapolations;
                RawMetricValues rawValues = (RawMetricValues)this._rawMetrics.get(entity);
                if (rawValues == null) {
                    valuesAndExtrapolations = ValuesAndExtrapolations.empty(completeness.validWindowIndices().size(), this._metricDef);
                    valuesAndExtrapolations.setWindows(windows);
                    result.addResult(entity, valuesAndExtrapolations);
                    result.recordInvalidEntity(entity);
                    continue;
                }
                valuesAndExtrapolations = rawValues.aggregate(completeness.validWindowIndices(), this._metricDef);
                valuesAndExtrapolations.setWindows(windows);
                result.addResult(entity, valuesAndExtrapolations);
                if (rawValues.isValid(options.maxAllowedExtrapolationsPerEntity())) continue;
                result.recordInvalidEntity(entity);
            }
            MetricSampleAggregationResult<G, Entity> metricSampleAggregationResult = result;
            return metricSampleAggregationResult;
        }
        finally {
            this._windowRollingLock.unlock();
        }
    }

    public Map<E, ValuesAndExtrapolations> peekCurrentWindow() {
        this._windowRollingLock.lock();
        try {
            HashMap result = new HashMap();
            this._rawMetrics.forEach((entity, rawMetric) -> {
                ValuesAndExtrapolations vae = rawMetric.peekCurrentWindow(this._currentWindowIndex, this._metricDef);
                TreeSet<Long> currentWindows = new TreeSet<Long>(Collections.singleton(this._currentWindowIndex));
                vae.setWindows(this.toWindows(currentWindows));
                result.put(entity, vae);
            });
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this._windowRollingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSampleCompleteness<G, E> completeness(long from, long to, AggregationOptions<G, E> options) {
        this._windowRollingLock.lock();
        try {
            long fromWindowIndex = Math.max(this.windowIndex(from), this._oldestWindowIndex);
            long toWindowIndex = Math.min(this.windowIndex(to), this._currentWindowIndex - 1L);
            if (fromWindowIndex > this._currentWindowIndex || toWindowIndex < this._oldestWindowIndex) {
                MetricSampleCompleteness metricSampleCompleteness = new MetricSampleCompleteness(this.generation(), this._windowMs);
                return metricSampleCompleteness;
            }
            this.maybeUpdateAggregatorState();
            MetricSampleCompleteness<G, E> metricSampleCompleteness = this._aggregatorState.completeness(fromWindowIndex, toWindowIndex, this.interpretAggregationOptions(options), this.generation());
            return metricSampleCompleteness;
        }
        finally {
            this._windowRollingLock.unlock();
        }
    }

    public List<Long> availableWindows() {
        return this.getWindowList(this._oldestWindowIndex, this._currentWindowIndex - 1L);
    }

    public int numAvailableWindows() {
        return this.numAvailableWindows(-1L, Long.MAX_VALUE);
    }

    public int numAvailableWindows(long from, long to) {
        long fromWindowIndex = Math.max(this.windowIndex(from), this._oldestWindowIndex);
        long toWindowIndex = Math.min(this.windowIndex(to), this._currentWindowIndex - 1L);
        return Math.max(0, (int)(toWindowIndex - fromWindowIndex + 1L));
    }

    public List<Long> allWindows() {
        return this.getWindowList(this._oldestWindowIndex, this._currentWindowIndex);
    }

    public Long earliestWindow() {
        return this._rawMetrics.isEmpty() ? null : Long.valueOf(this._oldestWindowIndex * this._windowMs);
    }

    public int numSamples() {
        return this._rawMetrics.values().stream().mapToInt(RawMetricValues::numSamples).sum();
    }

    public void retainEntities(Set<E> entities) {
        boolean anyElementsRemoved = this._rawMetrics.entrySet().removeIf(entry -> !entities.contains(entry.getKey()));
        if (anyElementsRemoved) {
            this._generation.incrementAndGet();
        }
    }

    public void removeEntities(Set<E> entities) {
        boolean anyElementsRemoved = this._rawMetrics.entrySet().removeIf(entry -> entities.contains(entry.getKey()));
        if (anyElementsRemoved) {
            this._generation.incrementAndGet();
        }
    }

    public void retainEntityGroup(Set<G> entityGroups) {
        boolean anyElementsRemoved = this._rawMetrics.entrySet().removeIf(entry -> !entityGroups.contains(((Entity)entry.getKey()).group()));
        if (anyElementsRemoved) {
            this._generation.incrementAndGet();
        }
    }

    public void removeEntityGroup(Set<G> entityGroups) {
        boolean anyElementsRemoved = this._rawMetrics.entrySet().removeIf(entry -> entityGroups.contains(((Entity)entry.getKey()).group()));
        if (anyElementsRemoved) {
            this._generation.incrementAndGet();
        }
    }

    public void clear() {
        this._windowRollingLock.lock();
        try {
            this._rawMetrics.clear();
            this._aggregatorState.clear();
            this._generation.incrementAndGet();
        }
        finally {
            this._windowRollingLock.unlock();
        }
    }

    MetricSampleAggregatorState<G, E> aggregatorState() {
        this.maybeUpdateAggregatorState();
        return this._aggregatorState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getWindowList(long fromWindowIndex, long toWindowIndex) {
        this._windowRollingLock.lock();
        try {
            if (this._rawMetrics.isEmpty()) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            ArrayList<Long> windows = new ArrayList<Long>((int)(toWindowIndex - fromWindowIndex + 1L));
            for (long i = fromWindowIndex; i <= toWindowIndex; ++i) {
                windows.add(i * this._windowMs);
            }
            ArrayList<Long> arrayList = windows;
            return arrayList;
        }
        finally {
            this._windowRollingLock.unlock();
        }
    }

    private void maybeUpdateAggregatorState() {
        long currentGeneration = this.generation();
        for (long windowIndex : this._aggregatorState.windowIndicesToUpdate(this._oldestWindowIndex, this._currentWindowIndex)) {
            this._aggregatorState.updateWindowState(windowIndex, this.getWindowState(windowIndex, currentGeneration));
        }
    }

    private WindowState<G, E> getWindowState(long windowIndex, long currentGeneration) {
        WindowState windowState = new WindowState(currentGeneration);
        for (Map.Entry entry : this._rawMetrics.entrySet()) {
            Entity entity = (Entity)entry.getKey();
            RawMetricValues rawValues = (RawMetricValues)entry.getValue();
            rawValues.sanityCheckWindowIndex(windowIndex);
            if (rawValues.isExtrapolatedAtWindowIndex(windowIndex)) {
                windowState.addExtrapolatedEntities(entity);
            }
            if (!rawValues.isValidAtWindowIndex(windowIndex)) continue;
            windowState.addValidEntities(entity);
        }
        return windowState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeRollOutNewWindow(long windowIndex) {
        if (this._currentWindowIndex < windowIndex) {
            this._windowRollingLock.lock();
            try {
                if (this._currentWindowIndex < windowIndex) {
                    int numWindowsToRollOut = (int)(windowIndex - this._currentWindowIndex);
                    long prevOldestWindowIndex = this._oldestWindowIndex;
                    this._oldestWindowIndex = Math.max(1L, windowIndex - (long)this._numWindows);
                    int numOldWindowIndicesToReset = (int)Math.min((long)this._numWindowsToKeep, this._oldestWindowIndex - prevOldestWindowIndex);
                    int numAbandonedSamples = 0;
                    if (numOldWindowIndicesToReset > 0) {
                        numAbandonedSamples = this.resetIndices(prevOldestWindowIndex, numOldWindowIndicesToReset);
                    }
                    this._aggregatorState.updateWindowGeneration(this._currentWindowIndex, this.generation());
                    this._currentWindowIndex = windowIndex;
                    LOG.info("{} Aggregator rolled out {} new windows, reset {} windows, current window range [{}, {}], abandon {} samples.", new Object[]{this._sampleType, numWindowsToRollOut, numOldWindowIndicesToReset, this._oldestWindowIndex * this._windowMs, this._currentWindowIndex * this._windowMs, numAbandonedSamples});
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this._windowRollingLock.unlock();
            }
        }
        return false;
    }

    private int resetRawValueIndices(long prevOldestWindowIndex, int numIndicesToReset, long currentOldestWindowIndex) {
        RawMetricValues rawValues;
        int numAbandonedSamples = 0;
        Iterator iterator = this._rawMetrics.values().iterator();
        if (iterator.hasNext()) {
            rawValues = (RawMetricValues)iterator.next();
            rawValues.updateOldestWindowIndex(currentOldestWindowIndex);
            rawValues.sanityCheckWindowRangeReset(prevOldestWindowIndex, numIndicesToReset);
            numAbandonedSamples += rawValues.resetWindowIndices(prevOldestWindowIndex, numIndicesToReset);
        }
        while (iterator.hasNext()) {
            rawValues = (RawMetricValues)iterator.next();
            rawValues.updateOldestWindowIndex(currentOldestWindowIndex);
            numAbandonedSamples += rawValues.resetWindowIndices(prevOldestWindowIndex, numIndicesToReset);
        }
        return numAbandonedSamples;
    }

    private int resetIndices(long prevOldestWindowIndex, int numIndicesToReset) {
        long currentOldestWindowIndex = this._oldestWindowIndex;
        int numAbandonedSamples = this.resetRawValueIndices(prevOldestWindowIndex, numIndicesToReset, currentOldestWindowIndex);
        this._aggregatorState.updateOldestWindowIndex(currentOldestWindowIndex);
        this._aggregatorState.resetWindowIndices(prevOldestWindowIndex, numIndicesToReset);
        return numAbandonedSamples;
    }

    private void validateCompleteness(long from, long to, MetricSampleCompleteness completeness, AggregationOptions<G, E> options) throws NotEnoughValidWindowsException {
        if (completeness.validWindowIndices().size() < options.minValidWindows()) {
            throw new NotEnoughValidWindowsException(String.format("There are only %d valid windows when aggregating in range [%d, %d] for aggregation options %s", completeness.validWindowIndices().size(), from, to, options));
        }
        if ((double)completeness.validEntityRatio() < options.minValidEntityRatio()) {
            throw new IllegalStateException(String.format("The entity coverage %.3f in range [%d, %d] for option %s does not meet requirement.", Float.valueOf(completeness.validEntityRatio()), from, to, options));
        }
        if ((double)completeness.validEntityGroupRatio() < options.minValidEntityGroupRatio()) {
            throw new IllegalStateException(String.format("The entity group coverage %.3f in range [%d, %d] for option %s does not meet requirement.", Float.valueOf(completeness.validEntityGroupRatio()), from, to, options));
        }
    }

    private List<Long> toWindows(SortedSet<Long> windowIndices) {
        ArrayList<Long> windows = new ArrayList<Long>(windowIndices.size());
        windowIndices.forEach(i -> windows.add(i * this._windowMs));
        return windows;
    }

    private long windowIndex(long time) {
        return time / this._windowMs + 1L;
    }

    private AggregationOptions<G, E> interpretAggregationOptions(AggregationOptions<G, E> options) {
        HashSet<Object> entitiesToInclude = new HashSet<Object>();
        if (options.interestedEntities().isEmpty()) {
            entitiesToInclude.addAll(this._rawMetrics.keySet());
        } else {
            for (Entity entity : options.interestedEntities()) {
                entitiesToInclude.add(this.identity(entity));
            }
        }
        return new AggregationOptions(options.minValidEntityRatio(), options.minValidEntityGroupRatio(), options.minValidWindows(), options.maxAllowedExtrapolationsPerEntity(), entitiesToInclude, options.granularity(), options.includeInvalidEntities());
    }

    protected E identity(E entity) {
        return (E)this._identityEntityMap.computeIfAbsent(entity, e -> entity);
    }

    public long monitoringPeriodMs() {
        return this._monitoringPeriodMs;
    }

    protected static enum SampleType {
        BROKER,
        PARTITION;

    }
}

