/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetricSampleAggregationResult<G, E extends Entity<G>>
extends LongGenerationed {
    private final Map<E, ValuesAndExtrapolations> _entityValuesAndExtrapolations = new HashMap<E, ValuesAndExtrapolations>();
    private final Set<E> _invalidEntities = new HashSet();
    private final MetricSampleCompleteness<G, E> _completeness;

    public MetricSampleAggregationResult(long generation, MetricSampleCompleteness<G, E> completeness) {
        super(generation);
        this._completeness = completeness;
    }

    public Map<E, ValuesAndExtrapolations> valuesAndExtrapolations() {
        return this._entityValuesAndExtrapolations;
    }

    public Set<E> invalidEntities() {
        return this._invalidEntities;
    }

    public MetricSampleCompleteness<G, E> completeness() {
        return this._completeness;
    }

    void addResult(E entity, ValuesAndExtrapolations valuesAndExtrapolations) {
        this._entityValuesAndExtrapolations.put(entity, valuesAndExtrapolations);
    }

    void recordInvalidEntity(E entity) {
        this._invalidEntities.add(entity);
    }

    @Override
    public void setGeneration(Long generation) {
        throw new RuntimeException("The generation of the MetricSampleAggregationResult is immutable.");
    }
}

