/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.model.Entity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AggregationOptions<G, E extends Entity<G>> {
    private final double _minValidEntityRatio;
    private final double _minValidEntityGroupRatio;
    private final int _minValidWindows;
    private final int _maxAllowedExtrapolationsPerEntity;
    private final Set<E> _interestedEntities;
    private final Granularity _granularity;
    private final boolean _includeInvalidEntities;
    private final Set<G> _interestedEntityGroups;

    public AggregationOptions(double minValidEntityRatio, double minValidEntityGroupRatio, int minValidWindows, int maxAllowedExtrapolationsPerEntity, Set<E> interestedEntities, Granularity granularity, boolean includeInvalidEntities) {
        if (minValidWindows < 1) {
            throw new IllegalArgumentException("The minimum valid windows must be at least 1");
        }
        this._minValidEntityRatio = minValidEntityRatio;
        this._minValidEntityGroupRatio = minValidEntityGroupRatio;
        this._minValidWindows = minValidWindows;
        this._maxAllowedExtrapolationsPerEntity = maxAllowedExtrapolationsPerEntity;
        this._interestedEntities = interestedEntities == null ? Collections.emptySet() : interestedEntities;
        this._granularity = granularity == null ? Granularity.ENTITY : granularity;
        this._includeInvalidEntities = includeInvalidEntities;
        this._interestedEntityGroups = new HashSet<G>();
        this._interestedEntities.forEach(entity -> this._interestedEntityGroups.add(entity.group()));
    }

    public double minValidEntityRatio() {
        return this._minValidEntityRatio;
    }

    public double minValidEntityGroupRatio() {
        return this._minValidEntityGroupRatio;
    }

    public int minValidWindows() {
        return this._minValidWindows;
    }

    public int maxAllowedExtrapolationsPerEntity() {
        return this._maxAllowedExtrapolationsPerEntity;
    }

    public Set<E> interestedEntities() {
        return Collections.unmodifiableSet(this._interestedEntities);
    }

    public Granularity granularity() {
        return this._granularity;
    }

    public boolean includeInvalidEntities() {
        return this._includeInvalidEntities;
    }

    public Set<G> interestedEntityGroups() {
        return Collections.unmodifiableSet(this._interestedEntityGroups);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._minValidEntityRatio, this._minValidEntityGroupRatio, this._minValidWindows, this._granularity, this._interestedEntities.size()});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationOptions)) {
            return false;
        }
        AggregationOptions other = (AggregationOptions)obj;
        if (this._minValidEntityRatio != other.minValidEntityRatio()) {
            return false;
        }
        if (this._minValidEntityGroupRatio != other.minValidEntityGroupRatio()) {
            return false;
        }
        if (this._minValidWindows != other.minValidWindows()) {
            return false;
        }
        if (this._granularity != other.granularity()) {
            return false;
        }
        if (this._maxAllowedExtrapolationsPerEntity != other.maxAllowedExtrapolationsPerEntity()) {
            return false;
        }
        if (this._interestedEntities.size() != other.interestedEntities().size()) {
            return false;
        }
        return this._interestedEntities.containsAll(other.interestedEntities());
    }

    public String toString() {
        return String.format("(minValidEntityRatio=%.2f, minValidEntityGroupRatio=%.2f, minValidWindows=%d, numEntitiesToInclude=%d, granularity=%s)", new Object[]{this._minValidEntityRatio, this._minValidEntityGroupRatio, this._minValidWindows, this._interestedEntities.size(), this._granularity});
    }

    public static enum Granularity {
        ENTITY,
        ENTITY_GROUP;

    }
}

