/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.model.Entity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class MetricSample<G, E extends Entity<G>> {
    protected final E _entity;
    protected final Map<Short, Double> _valuesByMetricId;
    protected long _sampleTime;

    public MetricSample(E entity) {
        this._entity = entity;
        this._valuesByMetricId = new HashMap<Short, Double>();
        this._sampleTime = -1L;
    }

    public void record(MetricInfo info, double sampleValue) {
        if (this._sampleTime >= 0L) {
            throw new IllegalStateException("The metric sample has been closed.");
        }
        Double origValue = this._valuesByMetricId.putIfAbsent(info.id(), sampleValue);
        if (origValue != null) {
            throw new IllegalStateException("Trying to record sample value " + sampleValue + " for " + info.name() + ", but there is already a value " + origValue + " recorded.");
        }
    }

    public E entity() {
        return this._entity;
    }

    public long sampleTime() {
        return this._sampleTime;
    }

    public Double metricValue(short metricId) {
        return this._valuesByMetricId.getOrDefault(metricId, Double.NaN);
    }

    public Map<Short, Double> allMetricValues() {
        return Collections.unmodifiableMap(this._valuesByMetricId);
    }

    public void close(long closingTime) {
        if (closingTime < 0L) {
            throw new IllegalArgumentException("Invalid closing time " + closingTime + ". The closing time cannot be negative.");
        }
        if (this._sampleTime < 0L) {
            this._sampleTime = closingTime;
        }
    }

    protected MetricDef metricDefForToString() {
        return null;
    }

    public boolean isValid(MetricDef metricDef) {
        return this._valuesByMetricId.size() == metricDef.size();
    }

    public String toString() {
        MetricDef metricDef = this.metricDefForToString();
        if (metricDef == null) {
            return String.format("{entity=%s,sampleTime=%d,metrics=%s}", this._entity, this._sampleTime, this._valuesByMetricId);
        }
        StringJoiner sj = new StringJoiner(",", "{", "}");
        sj.add(String.format("entity=(%s)", this._entity));
        sj.add(String.format("sampleTime=%d", this._sampleTime));
        for (MetricInfo metricInfo : this.metricDefForToString().all()) {
            sj.add(String.format("%s=%.3f", metricInfo.name(), this._valuesByMetricId.get(metricInfo.id())));
        }
        return sj.toString();
    }
}

