/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.metricdef;

import com.linkedin.cruisecontrol.CruiseControlUtils;
import com.linkedin.cruisecontrol.metricdef.AggregationFunction;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricDef {
    private final AtomicInteger _nextIndex = new AtomicInteger(0);
    private final Map<String, MetricInfo> _metricInfoByName = new HashMap<String, MetricInfo>();
    private final List<MetricInfo> _metricInfoByIndex = new ArrayList<MetricInfo>();
    private final Map<String, List<MetricInfo>> _metricInfoByGroup = new HashMap<String, List<MetricInfo>>();
    private final Set<Short> _metricsToPredict = new HashSet<Short>();
    private volatile boolean _doneDefinition = false;

    public synchronized MetricDef define(String metricName, String group, String valueComputingStrategy) {
        return this.define(metricName, group, valueComputingStrategy, false);
    }

    public synchronized MetricDef define(String metricName, String group, String valueComputingStrategy, boolean toPredict) {
        if (this._doneDefinition) {
            throw new IllegalStateException("Cannot add definition after the metric definition is done.");
        }
        CruiseControlUtils.ensureValidString("metricName", metricName);
        CruiseControlUtils.ensureValidString("valueComputingStrategy", valueComputingStrategy);
        this._metricInfoByName.compute(metricName, (k, v) -> {
            if (v != null) {
                throw new IllegalArgumentException("Metric " + metricName + " is already defined");
            }
            short metricId = this.getAndIncrementMetricId();
            if (toPredict) {
                this._metricsToPredict.add(metricId);
            }
            return new MetricInfo(metricName, metricId, AggregationFunction.valueOf(valueComputingStrategy.toUpperCase()), group);
        });
        MetricInfo info = this._metricInfoByName.get(metricName);
        this._metricInfoByIndex.add(info.id(), info);
        if (group != null && !group.isEmpty()) {
            this._metricInfoByGroup.computeIfAbsent(group, g -> new ArrayList()).add(info);
        }
        return this;
    }

    private short getAndIncrementMetricId() {
        int metricId = this._nextIndex.getAndIncrement();
        if (metricId > Short.MAX_VALUE) {
            throw new IllegalStateException(String.format("Metric Ids beyond %d are not supported.", (short)Short.MAX_VALUE));
        }
        return (short)metricId;
    }

    public List<MetricInfo> metricInfoForGroup(String group) {
        return this._metricInfoByGroup.getOrDefault(group, Collections.emptyList());
    }

    public synchronized void doneDefinition() {
        this._doneDefinition = true;
    }

    public MetricInfo metricInfo(String name) {
        MetricInfo info = this._metricInfoByName.get(name);
        if (info == null) {
            throw new IllegalArgumentException("Metric name " + name + " is not defined. Currently defined metrics are " + this._metricInfoByName);
        }
        return info;
    }

    public MetricInfo metricInfo(short id) {
        if (id >= this._nextIndex.get()) {
            throw new IllegalArgumentException("Metric Id " + id + " is not defined. Currently defined metrics are " + this._metricInfoByIndex);
        }
        return this._metricInfoByIndex.get(id);
    }

    public Set<Short> metricsToPredict() {
        return this._metricsToPredict;
    }

    public List<MetricInfo> all() {
        return Collections.unmodifiableList(this._metricInfoByIndex);
    }

    public int size() {
        return this._metricInfoByName.size();
    }
}

