/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.detector.metricanomaly;

import com.linkedin.cruisecontrol.CruiseControlUtils;
import com.linkedin.cruisecontrol.detector.metricanomaly.MetricAnomaly;
import com.linkedin.cruisecontrol.detector.metricanomaly.MetricAnomalyFinder;
import com.linkedin.cruisecontrol.detector.metricanomaly.PercentileMetricAnomalyFinderConfig;
import com.linkedin.cruisecontrol.detector.metricanomaly.PercentileMetricAnomalyFinderUtils;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PercentileMetricAnomalyFinder<E extends Entity>
implements MetricAnomalyFinder<E> {
    private static final Logger LOG = LoggerFactory.getLogger(PercentileMetricAnomalyFinder.class);
    private final Percentile _percentile = new Percentile();
    protected double _anomalyUpperMargin;
    protected double _anomalyLowerMargin;
    protected Double _anomalyUpperPercentile;
    protected Double _anomalyLowerPercentile;
    protected Set<String> _interestedMetrics;

    private MetricAnomaly<E> getAnomalyForMetric(E entity, Short metricId, ValuesAndExtrapolations history, ValuesAndExtrapolations current) {
        MetricValues historyMetricValues = history.metricValues().valuesFor(metricId);
        if (historyMetricValues == null) {
            return null;
        }
        this._percentile.setData(historyMetricValues.doubleArray());
        double upperPercentileMetricValue = this._percentile.evaluate(this._anomalyUpperPercentile.doubleValue());
        if (upperPercentileMetricValue <= 1.0) {
            return null;
        }
        double upperThreshold = upperPercentileMetricValue * (1.0 + this._anomalyUpperMargin);
        double lowerThreshold = this._percentile.evaluate(this._anomalyLowerPercentile.doubleValue()) * this._anomalyLowerMargin;
        double currentMetricValue = current.metricValues().valuesFor(metricId).latest();
        long currentWindow = current.window(0);
        if (currentMetricValue > upperThreshold || currentMetricValue < lowerThreshold) {
            String description = this.description(entity, metricId, currentWindow, history.windows(), currentMetricValue, upperThreshold, lowerThreshold);
            return this.createMetricAnomaly(description, entity, metricId, current.windows());
        }
        return null;
    }

    protected String description(E entity, Short metricId, Long currentWindow, List<Long> historyWindows, double currentMetricValue, double upperThreshold, double lowerThreshold) {
        int numHistoryWindows = historyWindows.size();
        return String.format("Metric value %.3f of %s for %s in window %s is out of the normal range for percentile: [%.2f, %.2f] (value: [%.3f, %.3f] with margins (lower: %.3f, upper: %.3f)) in %d history windows from %s to %s.", currentMetricValue, this.toMetricName(metricId), entity, CruiseControlUtils.toPrettyTime(currentWindow), this._anomalyLowerPercentile, this._anomalyUpperPercentile, lowerThreshold, upperThreshold, this._anomalyLowerMargin, this._anomalyUpperMargin, numHistoryWindows, CruiseControlUtils.toPrettyTime(historyWindows.get(0)), CruiseControlUtils.toPrettyTime(historyWindows.get(numHistoryWindows - 1)));
    }

    protected abstract String toMetricName(Short var1);

    protected abstract MetricAnomaly<E> createMetricAnomaly(String var1, E var2, Short var3, List<Long> var4);

    @Override
    public Collection<MetricAnomaly<E>> metricAnomalies(Map<E, ValuesAndExtrapolations> metricsHistoryByEntity, Map<E, ValuesAndExtrapolations> currentMetricsByEntity) {
        if (metricsHistoryByEntity == null || currentMetricsByEntity == null) {
            throw new IllegalArgumentException("Metrics history or current metrics cannot be null.");
        }
        if (metricsHistoryByEntity.isEmpty() || !PercentileMetricAnomalyFinderUtils.isDataSufficient(metricsHistoryByEntity.values().iterator().next().metricValues().length(), this._anomalyUpperPercentile, this._anomalyLowerPercentile)) {
            return Collections.emptySet();
        }
        HashSet<MetricAnomaly<MetricAnomaly<Entity>>> metricAnomalies = new HashSet<MetricAnomaly<MetricAnomaly<Entity>>>();
        for (Map.Entry<E, ValuesAndExtrapolations> entry : currentMetricsByEntity.entrySet()) {
            Entity entity = (Entity)entry.getKey();
            ValuesAndExtrapolations history = metricsHistoryByEntity.get(entity);
            if (history == null) continue;
            ValuesAndExtrapolations current = currentMetricsByEntity.get(entity);
            List<Long> windows = current.windows();
            for (Short metricId : entry.getValue().metricValues().metricIds()) {
                if (!this._interestedMetrics.contains(this.toMetricName(metricId))) continue;
                MetricAnomaly<Entity> metricAnomaly = this.getAnomalyForMetric(entity, metricId, history, current);
                LOG.trace("Anomaly for metric id {} for entity {} in time frame {}: {}.", new Object[]{metricId, entity, windows, metricAnomaly == null ? "none" : metricAnomaly.description()});
                if (metricAnomaly == null) continue;
                metricAnomalies.add(metricAnomaly);
            }
        }
        return metricAnomalies;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        PercentileMetricAnomalyFinderConfig internalConfig = new PercentileMetricAnomalyFinderConfig(configs);
        this._anomalyUpperPercentile = internalConfig.getDouble("metric.anomaly.percentile.upper.threshold");
        this._anomalyLowerPercentile = internalConfig.getDouble("metric.anomaly.percentile.lower.threshold");
        this._anomalyUpperMargin = internalConfig.getDouble("metric.anomaly.upper.margin");
        this._anomalyLowerMargin = internalConfig.getDouble("metric.anomaly.lower.margin");
        String trimmedMetrics = ((String)configs.get("metric.anomaly.analyzer.metrics")).trim();
        this._interestedMetrics = new HashSet<String>(Arrays.asList(trimmedMetrics.split(",")));
        this._interestedMetrics.removeIf(String::isEmpty);
    }
}

