/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.config;

import com.linkedin.cruisecontrol.common.config.AbstractConfig;
import com.linkedin.cruisecontrol.common.config.ConfigDef;
import java.util.Map;

public class CruiseControlConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("metrics.window.ms", ConfigDef.Type.LONG, 3600000, ConfigDef.Range.atLeast(1), ConfigDef.Importance.HIGH, "The interval in millisecond that is covered by each window.Cruise control will aggregate all the metric samples whose timestamp fall into the same window. The metrics.window.ms must be greater than the metric.sampling.interval.ms.").define("num.metrics.windows", ConfigDef.Type.INT, 5, ConfigDef.Range.atLeast(1), ConfigDef.Importance.HIGH, "The maximum number of windows the load monitor would keep. Each window covers a time span defined by window.ms.").define("min.samples.per.metrics.window", ConfigDef.Type.INT, 3, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, "The minimum number of metric samples a valid window should have. If a partition does not have enough samples in a window, the entire group of the entity will be removed from the aggregated metrics result due to insufficient data.").define("max.allowed.extrapolations.per.entity", ConfigDef.Type.INT, 5, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "The maximum allowed number of extrapolations for each entity. An entity will be considered as invalid if the total number extrapolations in all the windows goes above this number.").define("metric.sample.aggregator.completeness.cache.size", ConfigDef.Type.INT, 5, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The metric sample aggregator cache the completeness metadata for fast query. This configuration configures The number of completeness cache slot to maintain.").define("metric.anomaly.analyzer.metrics", ConfigDef.Type.LIST, "", ConfigDef.Importance.MEDIUM, "The metric ids that the metric anomaly detector should detect if they are violated.");
    public static final String METRICS_WINDOW_MS_CONFIG = "metrics.window.ms";
    private static final String METRICS_WINDOW_MS_DOC = "The interval in millisecond that is covered by each window.Cruise control will aggregate all the metric samples whose timestamp fall into the same window. The metrics.window.ms must be greater than the metric.sampling.interval.ms.";
    public static final String NUM_METRICS_WINDOWS_CONFIG = "num.metrics.windows";
    private static final String NUM_METRICS_WINDOWS_DOC = "The maximum number of windows the load monitor would keep. Each window covers a time span defined by window.ms.";
    public static final String MIN_SAMPLES_PER_METRICS_WINDOW_CONFIG = "min.samples.per.metrics.window";
    private static final String MIN_SAMPLES_PER_METRICS_WINDOW_DOC = "The minimum number of metric samples a valid window should have. If a partition does not have enough samples in a window, the entire group of the entity will be removed from the aggregated metrics result due to insufficient data.";
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_ENTITY_CONFIG = "max.allowed.extrapolations.per.entity";
    private static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_ENTITY_DOC = "The maximum allowed number of extrapolations for each entity. An entity will be considered as invalid if the total number extrapolations in all the windows goes above this number.";
    public static final String METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG = "metric.sample.aggregator.completeness.cache.size";
    private static final String METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_DOC = "The metric sample aggregator cache the completeness metadata for fast query. This configuration configures The number of completeness cache slot to maintain.";
    public static final String METRIC_ANOMALY_FINDER_METRICS_CONFIG = "metric.anomaly.analyzer.metrics";
    private static final String METRIC_ANOMALY_ANALYZER_METRICS_DOC = "The metric ids that the metric anomaly detector should detect if they are violated.";

    private static ConfigDef mergeConfigDef(ConfigDef definition) {
        for (ConfigDef.ConfigKey configKey : definition.configKeys().values()) {
            if (CONFIG.configKeys().containsKey(configKey._name)) continue;
            CONFIG.define(configKey._name, configKey._type, configKey._defaultValue, configKey._validator, configKey._importance, configKey._documentation, configKey._group, configKey._orderInGroup, configKey._width, configKey._displayName, configKey._dependents, configKey._recommender);
        }
        return CONFIG;
    }

    public CruiseControlConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(CruiseControlConfig.mergeConfigDef(definition), originals, doLog);
    }

    public CruiseControlConfig(ConfigDef definition, Map<?, ?> originals) {
        super(CruiseControlConfig.mergeConfigDef(definition), originals);
    }

    public CruiseControlConfig(Map<String, Object> parsedConfig) {
        super(CONFIG, parsedConfig);
    }
}

