/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.common.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConfigValue {
    private final String _name;
    private Object _value;
    private List<Object> _recommendedValues;
    private final List<String> _errorMessages;
    private boolean _visible;

    public ConfigValue(String name) {
        this(name, null, new ArrayList<Object>(), new ArrayList<String>());
    }

    public ConfigValue(String name, Object value, List<Object> recommendedValues, List<String> errorMessages) {
        this._name = name;
        this._value = value;
        this._recommendedValues = recommendedValues;
        this._errorMessages = errorMessages;
        this._visible = true;
    }

    public String name() {
        return this._name;
    }

    public Object value() {
        return this._value;
    }

    public List<Object> recommendedValues() {
        return this._recommendedValues;
    }

    public List<String> errorMessages() {
        return this._errorMessages;
    }

    public boolean visible() {
        return this._visible;
    }

    public void value(Object value) {
        this._value = value;
    }

    public void recommendedValues(List<Object> recommendedValues) {
        this._recommendedValues = recommendedValues;
    }

    public void addErrorMessage(String errorMessage) {
        this._errorMessages.add(errorMessage);
    }

    public void visible(boolean visible) {
        this._visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return Objects.equals(this._name, that._name) && Objects.equals(this._value, that._value) && Objects.equals(this._recommendedValues, that._recommendedValues) && Objects.equals(this._errorMessages, that._errorMessages) && Objects.equals(this._visible, that._visible);
    }

    public int hashCode() {
        return Objects.hash(this._name, this._value, this._recommendedValues, this._errorMessages, this._visible);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this._name).append(",").append(this._value).append(",").append(this._recommendedValues).append(",").append(this._errorMessages).append(",").append(this._visible).append("]");
        return sb.toString();
    }
}

