/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.common.config;

import com.linkedin.cruisecontrol.common.config.ConfigException;
import com.linkedin.cruisecontrol.common.config.ConfigValue;
import com.linkedin.cruisecontrol.common.config.types.Password;
import com.linkedin.cruisecontrol.common.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ConfigDef {
    public static final Object NO_DEFAULT_VALUE = new Object();
    private final Map<String, ConfigKey> _configKeys;
    private final List<String> _groups;
    private Set<String> _configsWithNoParent;

    public ConfigDef() {
        this._configKeys = new LinkedHashMap<String, ConfigKey>();
        this._groups = new LinkedList<String>();
        this._configsWithNoParent = null;
    }

    public ConfigDef(ConfigDef base) {
        this._configKeys = new LinkedHashMap<String, ConfigKey>(base._configKeys);
        this._groups = new LinkedList<String>(base._groups);
        this._configsWithNoParent = null;
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this._configKeys.keySet());
    }

    public ConfigDef define(ConfigKey key) {
        if (this._configKeys.containsKey(key._name)) {
            throw new ConfigException("Configuration " + key._name + " is defined twice.");
        }
        if (key._group != null && !this._groups.contains(key._group)) {
            this._groups.add(key._group);
        }
        this._configKeys.put(key._name, key);
        return this;
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
        return this.define(new ConfigKey(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, dependents, recommender, false));
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents) {
        return this.define(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, dependents, null);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, Recommender recommender) {
        return this.define(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList(), recommender);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName) {
        return this.define(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList());
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, dependents, recommender);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, dependents, null);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, Recommender recommender) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList(), recommender);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList());
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, dependents, recommender);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, dependents, null);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, Recommender recommender) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList(), recommender);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList());
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation) {
        return this.define(name, type, defaultValue, validator, importance, documentation, null, -1, Width.NONE, name);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation) {
        return this.define(name, type, defaultValue, null, importance, documentation);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation);
    }

    public ConfigDef defineInternal(String name, Type type, Object defaultValue, Importance importance) {
        return this.define(new ConfigKey(name, type, defaultValue, null, importance, "", "", -1, Width.NONE, name, Collections.emptyList(), null, true));
    }

    public Map<String, ConfigKey> configKeys() {
        return this._configKeys;
    }

    public List<String> groups() {
        return this._groups;
    }

    public Map<String, Object> parse(Map<?, ?> props) {
        List<String> undefinedConfigKeys = this.undefinedDependentConfigs();
        if (!undefinedConfigKeys.isEmpty()) {
            String joined = Utils.join(undefinedConfigKeys, ",");
            throw new ConfigException("Some configurations in are referred in the dependents, but not defined: " + joined);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ConfigKey key : this._configKeys.values()) {
            values.put(key._name, this.parseValue(key, props.get(key._name), props.containsKey(key._name)));
        }
        return values;
    }

    Object parseValue(ConfigKey key, Object value, boolean isSet) {
        Object parsedValue;
        if (isSet) {
            parsedValue = ConfigDef.parseType(key._name, value, key._type);
        } else {
            if (NO_DEFAULT_VALUE.equals(key._defaultValue)) {
                throw new ConfigException("Missing required configuration \"" + key._name + "\" which has no default value.");
            }
            parsedValue = key._defaultValue;
        }
        if (key._validator != null) {
            key._validator.ensureValid(key._name, parsedValue);
        }
        return parsedValue;
    }

    public List<ConfigValue> validate(Map<String, String> props) {
        return new ArrayList<ConfigValue>(this.validateAll(props).values());
    }

    public Map<String, ConfigValue> validateAll(Map<String, String> props) {
        HashMap<String, ConfigValue> configValues = new HashMap<String, ConfigValue>();
        for (String string : this._configKeys.keySet()) {
            configValues.put(string, new ConfigValue(string));
        }
        List<String> undefinedConfigKeys = this.undefinedDependentConfigs();
        for (String undefinedConfigKey : undefinedConfigKeys) {
            ConfigValue undefinedConfigValue = new ConfigValue(undefinedConfigKey);
            undefinedConfigValue.addErrorMessage(undefinedConfigKey + " is referred in the dependents, but not defined.");
            undefinedConfigValue.visible(false);
            configValues.put(undefinedConfigKey, undefinedConfigValue);
        }
        Map<String, Object> map = this.parseForValidate(props, configValues);
        return this.validate(map, configValues);
    }

    Map<String, Object> parseForValidate(Map<String, String> props, Map<String, ConfigValue> configValues) {
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        Set<String> configsWithNoParent = this.getConfigsWithNoParent();
        for (String name : configsWithNoParent) {
            this.parseForValidate(name, props, parsed, configValues);
        }
        return parsed;
    }

    private Map<String, ConfigValue> validate(Map<String, Object> parsed, Map<String, ConfigValue> configValues) {
        Set<String> configsWithNoParent = this.getConfigsWithNoParent();
        for (String name : configsWithNoParent) {
            this.validate(name, parsed, configValues);
        }
        return configValues;
    }

    private List<String> undefinedDependentConfigs() {
        HashSet<String> undefinedConfigKeys = new HashSet<String>();
        for (ConfigKey configKey : this._configKeys.values()) {
            for (String dependent : configKey._dependents) {
                if (this._configKeys.containsKey(dependent)) continue;
                undefinedConfigKeys.add(dependent);
            }
        }
        return new ArrayList<String>(undefinedConfigKeys);
    }

    Set<String> getConfigsWithNoParent() {
        if (this._configsWithNoParent != null) {
            return this._configsWithNoParent;
        }
        HashSet<String> configsWithParent = new HashSet<String>();
        for (ConfigKey configKey : this._configKeys.values()) {
            List<String> dependents = configKey._dependents;
            configsWithParent.addAll(dependents);
        }
        HashSet<String> configs = new HashSet<String>(this._configKeys.keySet());
        configs.removeAll(configsWithParent);
        this._configsWithNoParent = configs;
        return configs;
    }

    private void parseForValidate(String name, Map<String, String> props, Map<String, Object> parsed, Map<String, ConfigValue> configs) {
        if (!this._configKeys.containsKey(name)) {
            return;
        }
        ConfigKey key = this._configKeys.get(name);
        ConfigValue config = configs.get(name);
        Object value = null;
        if (props.containsKey(key._name)) {
            try {
                value = ConfigDef.parseType(key._name, props.get(key._name), key._type);
            }
            catch (ConfigException e) {
                config.addErrorMessage(e.getMessage());
            }
        } else if (NO_DEFAULT_VALUE.equals(key._defaultValue)) {
            config.addErrorMessage("Missing required configuration \"" + key._name + "\" which has no default value.");
        } else {
            value = key._defaultValue;
        }
        if (key._validator != null) {
            try {
                key._validator.ensureValid(key._name, value);
            }
            catch (ConfigException e) {
                config.addErrorMessage(e.getMessage());
            }
        }
        config.value(value);
        parsed.put(name, value);
        for (String dependent : key._dependents) {
            this.parseForValidate(dependent, props, parsed, configs);
        }
    }

    private void validate(String name, Map<String, Object> parsed, Map<String, ConfigValue> configs) {
        if (!this._configKeys.containsKey(name)) {
            return;
        }
        ConfigKey key = this._configKeys.get(name);
        ConfigValue value = configs.get(name);
        if (key._recommender != null) {
            try {
                List<Object> recommendedValues = key._recommender.validValues(name, parsed);
                List<Object> originalRecommendedValues = value.recommendedValues();
                if (!originalRecommendedValues.isEmpty()) {
                    HashSet<Object> originalRecommendedValueSet = new HashSet<Object>(originalRecommendedValues);
                    recommendedValues.removeIf(o -> !originalRecommendedValueSet.contains(o));
                }
                value.recommendedValues(recommendedValues);
                value.visible(key._recommender.visible(name, parsed));
            }
            catch (ConfigException e) {
                value.addErrorMessage(e.getMessage());
            }
        }
        configs.put(name, value);
        for (String dependent : key._dependents) {
            this.validate(dependent, parsed, configs);
        }
    }

    public static Object parseType(String name, Object value, Type type) {
        try {
            if (value == null) {
                return null;
            }
            String trimmed = null;
            if (value instanceof String) {
                trimmed = ((String)value).trim();
            }
            switch (type) {
                case BOOLEAN: {
                    if (value instanceof String) {
                        if (trimmed.equalsIgnoreCase("true")) {
                            return true;
                        }
                        if (trimmed.equalsIgnoreCase("false")) {
                            return false;
                        }
                        throw new ConfigException(name, value, "Expected value to be either true or false");
                    }
                    if (value instanceof Boolean) {
                        return value;
                    }
                    throw new ConfigException(name, value, "Expected value to be either true or false");
                }
                case PASSWORD: {
                    if (value instanceof Password) {
                        return value;
                    }
                    if (value instanceof String) {
                        return new Password(trimmed);
                    }
                    throw new ConfigException(name, value, "Expected value to be a string, but it was a " + value.getClass().getName());
                }
                case STRING: {
                    if (value instanceof String) {
                        return trimmed;
                    }
                    throw new ConfigException(name, value, "Expected value to be a string, but it was a " + value.getClass().getName());
                }
                case INT: {
                    if (value instanceof Integer) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Integer.parseInt(trimmed);
                    }
                    throw new ConfigException(name, value, "Expected value to be a 32-bit integer, but it was a " + value.getClass().getName());
                }
                case SHORT: {
                    if (value instanceof Short) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Short.parseShort(trimmed);
                    }
                    throw new ConfigException(name, value, "Expected value to be a 16-bit integer (short), but it was a " + value.getClass().getName());
                }
                case LONG: {
                    if (value instanceof Integer) {
                        return ((Integer)value).longValue();
                    }
                    if (value instanceof Long) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Long.parseLong(trimmed);
                    }
                    throw new ConfigException(name, value, "Expected value to be a 64-bit integer (long), but it was a " + value.getClass().getName());
                }
                case DOUBLE: {
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    if (value instanceof String) {
                        return Double.parseDouble(trimmed);
                    }
                    throw new ConfigException(name, value, "Expected value to be a double, but it was a " + value.getClass().getName());
                }
                case LIST: {
                    if (value instanceof List) {
                        return value;
                    }
                    if (value instanceof String) {
                        if (trimmed.isEmpty()) {
                            return Collections.emptyList();
                        }
                        return Arrays.asList(trimmed.split("\\s*,\\s*", -1));
                    }
                    throw new ConfigException(name, value, "Expected a comma separated list.");
                }
                case CLASS: {
                    if (value instanceof Class) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Class.forName(trimmed, true, Utils.getContextOrCruiseControlClassLoader());
                    }
                    throw new ConfigException(name, value, "Expected a Class instance or class name.");
                }
            }
            throw new IllegalStateException("Unknown type.");
        }
        catch (NumberFormatException e) {
            throw new ConfigException(name, value, "Not a number of type " + type);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(name, value, "Class " + value + " could not be found.");
        }
    }

    public static String convertToString(Object parsedValue, Type type) {
        if (parsedValue == null) {
            return null;
        }
        if (type == null) {
            return parsedValue.toString();
        }
        switch (type) {
            case BOOLEAN: 
            case PASSWORD: 
            case STRING: 
            case INT: 
            case SHORT: 
            case LONG: 
            case DOUBLE: {
                return parsedValue.toString();
            }
            case LIST: {
                List valueList = (List)parsedValue;
                return Utils.join(valueList, ",");
            }
            case CLASS: {
                Class clazz = (Class)parsedValue;
                return clazz.getName();
            }
        }
        throw new IllegalStateException("Unknown type.");
    }

    protected List<String> headers() {
        return Arrays.asList("Name", "Description", "Type", "Default", "Valid Values", "Importance");
    }

    protected String getConfigValue(ConfigKey key, String headerName) {
        switch (headerName) {
            case "Name": {
                return key._name;
            }
            case "Description": {
                return key._documentation;
            }
            case "Type": {
                return key._type.toString().toLowerCase(Locale.ROOT);
            }
            case "Default": {
                if (key.hasDefault()) {
                    if (key._defaultValue == null) {
                        return "null";
                    }
                    String defaultValueStr = ConfigDef.convertToString(key._defaultValue, key._type);
                    if (defaultValueStr.isEmpty()) {
                        return "\"\"";
                    }
                    return defaultValueStr;
                }
                return "";
            }
            case "Valid Values": {
                return key._validator != null ? key._validator.toString() : "";
            }
            case "Importance": {
                return key._importance.toString().toLowerCase(Locale.ROOT);
            }
        }
        throw new RuntimeException("Can't find value for header '" + headerName + "' in " + key._name);
    }

    public String toHtmlTable() {
        List<ConfigKey> configs = this.sortedConfigs();
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>\n");
        for (String headerName : this.headers()) {
            b.append("<th>");
            b.append(headerName);
            b.append("</th>\n");
        }
        b.append("</tr>\n");
        for (ConfigKey key : configs) {
            if (key._internalConfig) continue;
            b.append("<tr>\n");
            for (String headerName : this.headers()) {
                b.append("<td>");
                b.append(this.getConfigValue(key, headerName));
                b.append("</td>");
            }
            b.append("</tr>\n");
        }
        b.append("</tbody></table>");
        return b.toString();
    }

    public String toRst() {
        StringBuilder b = new StringBuilder();
        for (ConfigKey key : this.sortedConfigs()) {
            if (key._internalConfig) continue;
            this.getConfigKeyRst(key, b);
            b.append("\n");
        }
        return b.toString();
    }

    public String toEnrichedRst() {
        StringBuilder b = new StringBuilder();
        String lastKeyGroupName = "";
        for (ConfigKey key : this.sortedConfigs()) {
            if (key._internalConfig) continue;
            if (key._group != null) {
                if (!lastKeyGroupName.equalsIgnoreCase(key._group)) {
                    b.append(key._group).append("\n");
                    char[] underLine = new char[key._group.length()];
                    Arrays.fill(underLine, '^');
                    b.append(new String(underLine)).append("\n\n");
                }
                lastKeyGroupName = key._group;
            }
            this.getConfigKeyRst(key, b);
            if (key._dependents != null && key._dependents.size() > 0) {
                int j = 0;
                b.append("  * Dependents: ");
                for (String dependent : key._dependents) {
                    b.append("``");
                    b.append(dependent);
                    if (++j == key._dependents.size()) {
                        b.append("``");
                        continue;
                    }
                    b.append("``, ");
                }
                b.append("\n");
            }
            b.append("\n");
        }
        return b.toString();
    }

    private void getConfigKeyRst(ConfigKey key, StringBuilder b) {
        b.append("``").append(key._name).append("``").append("\n");
        for (String docLine : key._documentation.split("\n")) {
            if (docLine.length() == 0) continue;
            b.append("  ").append(docLine).append("\n\n");
        }
        b.append("  * Type: ").append(this.getConfigValue(key, "Type")).append("\n");
        if (key.hasDefault()) {
            b.append("  * Default: ").append(this.getConfigValue(key, "Default")).append("\n");
        }
        if (key._validator != null) {
            b.append("  * Valid Values: ").append(this.getConfigValue(key, "Valid Values")).append("\n");
        }
        b.append("  * Importance: ").append(this.getConfigValue(key, "Importance")).append("\n");
    }

    private List<ConfigKey> sortedConfigs() {
        final HashMap<String, Integer> groupOrd = new HashMap<String, Integer>(this._groups.size());
        int ord = 0;
        for (String group : this._groups) {
            groupOrd.put(group, ord++);
        }
        ArrayList<ConfigKey> configs = new ArrayList<ConfigKey>(this._configKeys.values());
        configs.sort(new Comparator<ConfigKey>(){

            @Override
            public int compare(ConfigKey k1, ConfigKey k2) {
                int cmp;
                int n = k1._group == null ? (k2._group == null ? 0 : -1) : (cmp = k2._group == null ? 1 : Integer.compare((Integer)groupOrd.get(k1._group), (Integer)groupOrd.get(k2._group)));
                if (cmp == 0 && (cmp = Integer.compare(k1._orderInGroup, k2._orderInGroup)) == 0) {
                    if (!k1.hasDefault() && k2.hasDefault()) {
                        cmp = -1;
                    } else if (!k2.hasDefault() && k1.hasDefault()) {
                        cmp = 1;
                    } else {
                        cmp = k1._importance.compareTo(k2._importance);
                        if (cmp == 0) {
                            return k1._name.compareTo(k2._name);
                        }
                    }
                }
                return cmp;
            }
        });
        return configs;
    }

    public void embed(String keyPrefix, String groupPrefix, int startingOrd, ConfigDef child) {
        int orderInGroup = startingOrd;
        for (ConfigKey key : child.sortedConfigs()) {
            this.define(new ConfigKey(keyPrefix + key._name, key._type, key._defaultValue, ConfigDef.embeddedValidator(keyPrefix, key._validator), key._importance, key._documentation, groupPrefix + (String)(key._group == null ? "" : ": " + key._group), orderInGroup++, key._width, key._displayName, ConfigDef.embeddedDependents(keyPrefix, key._dependents), ConfigDef.embeddedRecommender(keyPrefix, key._recommender), key._internalConfig));
        }
    }

    private static Validator embeddedValidator(final String keyPrefix, final Validator base) {
        if (base == null) {
            return null;
        }
        return new Validator(){

            @Override
            public void ensureValid(String name, Object value) {
                base.ensureValid(name.substring(keyPrefix.length()), value);
            }
        };
    }

    private static List<String> embeddedDependents(String keyPrefix, List<String> dependents) {
        if (dependents == null) {
            return null;
        }
        ArrayList<String> updatedDependents = new ArrayList<String>(dependents.size());
        for (String dependent : dependents) {
            updatedDependents.add(keyPrefix + dependent);
        }
        return updatedDependents;
    }

    private static Recommender embeddedRecommender(final String keyPrefix, final Recommender base) {
        if (base == null) {
            return null;
        }
        return new Recommender(){

            private String unprefixed(String k) {
                return k.substring(keyPrefix.length());
            }

            private Map<String, Object> unprefixed(Map<String, Object> parsedConfig) {
                HashMap<String, Object> unprefixedParsedConfig = new HashMap<String, Object>(parsedConfig.size());
                for (Map.Entry<String, Object> e : parsedConfig.entrySet()) {
                    if (!e.getKey().startsWith(keyPrefix)) continue;
                    unprefixedParsedConfig.put(this.unprefixed(e.getKey()), e.getValue());
                }
                return unprefixedParsedConfig;
            }

            @Override
            public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
                return base.validValues(this.unprefixed(name), this.unprefixed(parsedConfig));
            }

            @Override
            public boolean visible(String name, Map<String, Object> parsedConfig) {
                return base.visible(this.unprefixed(name), this.unprefixed(parsedConfig));
            }
        };
    }

    public static class ConfigKey {
        public final String _name;
        public final Type _type;
        public final String _documentation;
        public final Object _defaultValue;
        public final Validator _validator;
        public final Importance _importance;
        public final String _group;
        public final int _orderInGroup;
        public final Width _width;
        public final String _displayName;
        public final List<String> _dependents;
        public final Recommender _recommender;
        public final boolean _internalConfig;

        public ConfigKey(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender, boolean internalConfig) {
            this._name = name;
            this._type = type;
            this._defaultValue = NO_DEFAULT_VALUE.equals(defaultValue) ? NO_DEFAULT_VALUE : ConfigDef.parseType(name, defaultValue, type);
            this._validator = validator;
            this._importance = importance;
            if (this._validator != null && this.hasDefault()) {
                this._validator.ensureValid(name, this._defaultValue);
            }
            this._documentation = documentation;
            this._dependents = dependents;
            this._group = group;
            this._orderInGroup = orderInGroup;
            this._width = width;
            this._displayName = displayName;
            this._recommender = recommender;
            this._internalConfig = internalConfig;
        }

        public boolean hasDefault() {
            return !NO_DEFAULT_VALUE.equals(this._defaultValue);
        }
    }

    public static class NonEmptyString
    implements Validator {
        @Override
        public void ensureValid(String name, Object o) {
            String s = (String)o;
            if (s != null && s.isEmpty()) {
                throw new ConfigException(name, o, "String must be non-empty");
            }
        }

        public String toString() {
            return "non-empty string";
        }
    }

    public static class ValidString
    implements Validator {
        final List<String> _validStrings;

        private ValidString(List<String> validStrings) {
            this._validStrings = validStrings;
        }

        public static ValidString in(String ... validStrings) {
            return new ValidString(Arrays.asList(validStrings));
        }

        @Override
        public void ensureValid(String name, Object o) {
            String s = (String)o;
            if (!this._validStrings.contains(s)) {
                throw new ConfigException(name, o, "String must be one of: " + Utils.join(this._validStrings, ", "));
            }
        }

        public String toString() {
            return "[" + Utils.join(this._validStrings, ", ") + "]";
        }
    }

    public static class ValidList
    implements Validator {
        final ValidString _validString;

        private ValidList(List<String> validStrings) {
            this._validString = new ValidString(validStrings);
        }

        public static ValidList in(String ... validStrings) {
            return new ValidList(Arrays.asList(validStrings));
        }

        @Override
        public void ensureValid(String name, Object value) {
            List values = (List)value;
            for (String string : values) {
                this._validString.ensureValid(name, string);
            }
        }

        public String toString() {
            return this._validString.toString();
        }
    }

    public static class Range
    implements Validator {
        private final Number _min;
        private final Number _max;

        private Range(Number min, Number max) {
            this._min = min;
            this._max = max;
        }

        public static Range atLeast(Number min) {
            return new Range(min, null);
        }

        public static Range between(Number min, Number max) {
            return new Range(min, max);
        }

        @Override
        public void ensureValid(String name, Object o) {
            if (o == null) {
                throw new ConfigException(name, null, "Value must be non-null");
            }
            Number n = (Number)o;
            if (this._min != null && n.doubleValue() < this._min.doubleValue()) {
                throw new ConfigException(name, o, "Value must be at least " + this._min);
            }
            if (this._max != null && n.doubleValue() > this._max.doubleValue()) {
                throw new ConfigException(name, o, "Value must be no more than " + this._max);
            }
        }

        public String toString() {
            if (this._min == null) {
                return "[...," + this._max + "]";
            }
            if (this._max == null) {
                return "[" + this._min + ",...]";
            }
            return "[" + this._min + ",...," + this._max + "]";
        }
    }

    public static interface Validator {
        public void ensureValid(String var1, Object var2);
    }

    public static interface Recommender {
        public List<Object> validValues(String var1, Map<String, Object> var2);

        public boolean visible(String var1, Map<String, Object> var2);
    }

    public static enum Width {
        NONE,
        SHORT,
        MEDIUM,
        LONG;

    }

    public static enum Importance {
        HIGH,
        MEDIUM,
        LOW;

    }

    public static enum Type {
        BOOLEAN,
        STRING,
        INT,
        SHORT,
        LONG,
        DOUBLE,
        LIST,
        CLASS,
        PASSWORD;

    }
}

