/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.common.config;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurable;
import com.linkedin.cruisecontrol.common.config.ConfigDef;
import com.linkedin.cruisecontrol.common.config.ConfigException;
import com.linkedin.cruisecontrol.common.config.types.Password;
import com.linkedin.cruisecontrol.common.utils.Utils;
import com.linkedin.cruisecontrol.exception.CruiseControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    public static final String NL = System.getProperty("line.separator");
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> _used;
    private final Map<String, ?> _originals;
    private final Map<String, Object> _values;
    private final ConfigDef _definition;

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        for (Map.Entry<?, ?> entry : originals.entrySet()) {
            if (entry.getKey() instanceof String) continue;
            throw new ConfigException(entry.getKey().toString(), entry.getValue(), "Key must be a string.");
        }
        this._originals = originals;
        this._values = definition.parse(this._originals);
        Map<String, Object> configUpdates = this.postProcessParsedConfig(Collections.unmodifiableMap(this._values));
        for (Map.Entry<String, Object> update : configUpdates.entrySet()) {
            this._values.put(update.getKey(), update.getValue());
        }
        definition.parse(this._values);
        this._used = Collections.synchronizedSet(new HashSet());
        this._definition = definition;
        if (doLog) {
            this.logAll();
        }
    }

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals) {
        this(definition, originals, true);
    }

    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return Collections.emptyMap();
    }

    protected Object get(String key) {
        if (!this._values.containsKey(key)) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        this._used.add(key);
        return this._values.get(key);
    }

    public void ignore(String key) {
        this._used.add(key);
    }

    public Short getShort(String key) {
        return (Short)this.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public List<String> getList(String key) {
        return (List)this.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public ConfigDef.Type typeOf(String key) {
        ConfigDef.ConfigKey configKey = this._definition.configKeys().get(key);
        if (configKey == null) {
            return null;
        }
        return configKey._type;
    }

    public Password getPassword(String key) {
        return (Password)this.get(key);
    }

    public Class<?> getClass(String key) {
        return (Class)this.get(key);
    }

    public Set<String> unused() {
        HashSet<String> keys = new HashSet<String>(this._originals.keySet());
        keys.removeAll(this._used);
        return keys;
    }

    public Map<String, Object> originals() {
        RecordingMap<Object> copy = new RecordingMap<Object>();
        copy.putAll(this._originals);
        return copy;
    }

    public Map<String, String> originalsStrings() {
        RecordingMap<String> copy = new RecordingMap<String>();
        for (Map.Entry<String, ?> entry : this._originals.entrySet()) {
            if (!(entry.getValue() instanceof String)) {
                throw new ClassCastException("Non-string value found in original settings for key " + entry.getKey() + ": " + (entry.getValue() == null ? null : entry.getValue().getClass().getName()));
            }
            copy.put(entry.getKey(), (String)entry.getValue());
        }
        return copy;
    }

    public Map<String, Object> originalsWithPrefix(String prefix) {
        RecordingMap<Object> result = new RecordingMap<Object>(prefix, false);
        for (Map.Entry<String, ?> entry : this._originals.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            result.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return result;
    }

    public Map<String, Object> valuesWithPrefixOverride(String prefix) {
        RecordingMap<Object> result = new RecordingMap<Object>(this.values(), prefix, true);
        for (Map.Entry<String, ?> entry : this._originals.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            String keyWithNoPrefix = entry.getKey().substring(prefix.length());
            ConfigDef.ConfigKey configKey = this._definition.configKeys().get(keyWithNoPrefix);
            if (configKey == null) continue;
            result.put(keyWithNoPrefix, this._definition.parseValue(configKey, entry.getValue(), true));
        }
        return result;
    }

    public Map<String, ?> values() {
        return new RecordingMap<Object>(this._values);
    }

    private void logAll() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append(" values: ");
        b.append(NL);
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(this._values).entrySet()) {
            b.append('\t');
            b.append(entry.getKey());
            b.append(" = ");
            b.append(entry.getValue());
            b.append(NL);
        }
        this._log.info(b.toString());
    }

    public void logUnused() {
        for (String key : this.unused()) {
            this._log.warn("The configuration '{}' was supplied but isn't a known config.", (Object)key);
        }
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) throws CruiseControlException {
        Class<?> c = this.getClass(key);
        if (c == null) {
            return null;
        }
        Object o = Utils.newInstance(c);
        if (!t.isInstance(o)) {
            throw new CruiseControlException(c.getName() + " is not an instance of " + t.getName());
        }
        if (o instanceof CruiseControlConfigurable) {
            ((CruiseControlConfigurable)o).configure(this.originals());
        }
        return t.cast(o);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) throws CruiseControlException {
        return this.getConfiguredInstances(key, t, Collections.EMPTY_MAP);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t, Map<String, Object> configOverrides) throws CruiseControlException {
        List<String> klasses = this.getList(key);
        ArrayList<T> objects = new ArrayList<T>();
        if (klasses == null) {
            return objects;
        }
        Map<String, Object> configPairs = this.originals();
        configPairs.putAll(configOverrides);
        for (String klass : klasses) {
            T o;
            if (klass instanceof String) {
                try {
                    o = Utils.newInstance(klass, t);
                }
                catch (ClassNotFoundException e) {
                    throw new CruiseControlException(klass + " ClassNotFoundException exception occurred", e);
                }
            } else if (klass instanceof Class) {
                o = Utils.newInstance((Class)((Object)klass));
            } else {
                throw new CruiseControlException("List contains element of type " + klass.getClass().getName() + ", expected String or Class");
            }
            if (!t.isInstance(o)) {
                throw new CruiseControlException(klass + " is not an instance of " + t.getName());
            }
            if (o instanceof CruiseControlConfigurable) {
                ((CruiseControlConfigurable)o).configure(configPairs);
            }
            objects.add(t.cast(o));
        }
        return objects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfig that = (AbstractConfig)o;
        return this._originals.equals(that._originals);
    }

    public int hashCode() {
        return this._originals.hashCode();
    }

    private class RecordingMap<V>
    extends HashMap<String, V> {
        private final String _prefix;
        private final boolean _withIgnoreFallback;

        RecordingMap() {
            this("", false);
        }

        RecordingMap(String prefix, boolean withIgnoreFallback) {
            this._prefix = prefix;
            this._withIgnoreFallback = withIgnoreFallback;
        }

        RecordingMap(Map<String, ? extends V> m) {
            this(m, "", false);
        }

        RecordingMap(Map<String, ? extends V> m, String prefix, boolean withIgnoreFallback) {
            super(m);
            this._prefix = prefix;
            this._withIgnoreFallback = withIgnoreFallback;
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                String stringKey = (String)key;
                Object keyWithPrefix = this._prefix.isEmpty() ? stringKey : this._prefix + stringKey;
                AbstractConfig.this.ignore((String)keyWithPrefix);
                if (this._withIgnoreFallback) {
                    AbstractConfig.this.ignore(stringKey);
                }
            }
            return super.get(key);
        }
    }
}

