/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.common;

public abstract class WindowIndexedArrays {
    public static final int INVALID_INDEX = -1;
    protected volatile long _oldestWindowIndex;

    public void updateOldestWindowIndex(long newOldestWindowIndex) {
        if (this._oldestWindowIndex >= newOldestWindowIndex) {
            throw new IllegalArgumentException("The new oldest window " + newOldestWindowIndex + " is no larger than the current oldest window " + this._oldestWindowIndex);
        }
        this._oldestWindowIndex = newOldestWindowIndex;
    }

    protected abstract int length();

    protected void validateWindowIndex(long windowIndex) {
        if (!this.inValidWindowRange(windowIndex)) {
            throw new IllegalArgumentException(String.format("Index %d is out of range [%d, %d]", windowIndex, this._oldestWindowIndex, this.lastWindowIndex()));
        }
    }

    protected int prevArrayIndex(int arrayIndex) {
        return arrayIndex == this.firstArrayIndex() ? -1 : (arrayIndex + this.length() - 1) % this.length();
    }

    protected int nextArrayIndex(int arrayIndex) {
        return arrayIndex == this.lastArrayIndex() ? -1 : (arrayIndex + 1) % this.length();
    }

    protected int firstArrayIndex() {
        return this.arrayIndex(this._oldestWindowIndex);
    }

    protected int lastArrayIndex() {
        return this.arrayIndex(this.lastWindowIndex());
    }

    protected long lastWindowIndex() {
        return this.currentWindowIndex() - 1L;
    }

    protected boolean inValidWindowRange(long windowIndex) {
        return windowIndex >= this._oldestWindowIndex && windowIndex <= this.lastWindowIndex();
    }

    protected long currentWindowIndex() {
        return this._oldestWindowIndex + (long)this.length() - 1L;
    }

    protected int arrayIndex(long windowIndex) {
        return (int)(windowIndex % (long)this.length());
    }
}

