/*
 * Decompiled with CFR 0.152.
 */
package com.linkdev.fileattachmentview.utils;

import com.linkdev.fileattachmentview.models.AttachFileData;
import com.linkdev.fileattachmentview.models.FileExtensions;
import com.linkdev.fileattachmentview.models.FileExtensionsData;
import com.linkdev.filepicker.models.FileData;
import com.linkdev.filepicker.models.FileTypes;
import com.linkdev.filepicker.models.MimeType;
import com.linkdev.filepicker.models.SelectionMode;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ-\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00102\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fJ.\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u000ej\b\u0012\u0004\u0012\u00020\u0019`\u00102\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u000ej\b\u0012\u0004\u0012\u00020\u001b`\u0010J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u000ej\b\u0012\u0004\u0012\u00020\u0019`\u0010J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\fJ\u0015\u0010\"\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"Lcom/linkdev/fileattachmentview/utils/Utils;", "", "()V", "bytesToMegaBytes", "", "bytes", "(Ljava/lang/Double;)D", "convertFileDataToAttachFileData", "Lcom/linkdev/fileattachmentview/models/AttachFileData;", "fileData", "Lcom/linkdev/filepicker/models/FileData;", "getCorrespondingAttachmentTypeIcon", "", "fileExtensionsDataList", "Ljava/util/ArrayList;", "Lcom/linkdev/fileattachmentview/models/FileExtensionsData;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;Lcom/linkdev/fileattachmentview/models/AttachFileData;)Ljava/lang/Integer;", "getCorrespondingFileSelectionMode", "Lcom/linkdev/filepicker/models/SelectionMode;", "selectionMode", "getCorrespondingFileType", "Lcom/linkdev/filepicker/models/FileTypes;", "fileType", "getCorrespondingMimeTypes", "Lcom/linkdev/filepicker/models/MimeType;", "mimeTypeNames", "", "getCorrespondingRequestCode", "getMimeTypesList", "isValidAttachmentSize", "", "attachmentSize", "maxFileSize", "isValidResource", "viewId", "(Ljava/lang/Integer;)Z", "FileAttachmentView_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidResource(@Nullable Integer viewId) {
        if (viewId == null) return false;
        int n = -1;
        if (viewId == n) return false;
        return true;
    }

    @NotNull
    public final ArrayList<MimeType> getCorrespondingMimeTypes(@NotNull ArrayList<String> mimeTypeNames) {
        Intrinsics.checkNotNullParameter(mimeTypeNames, (String)"mimeTypeNames");
        ArrayList<MimeType> mMimeTypeList = new ArrayList<MimeType>();
        for (String mimeTypeName : mimeTypeNames) {
            for (MimeType mimeType : this.getMimeTypesList()) {
                CharSequence charSequence = mimeType.getMimeTypeName();
                String string2 = mimeTypeName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mimeTypeName");
                if (!StringsKt.contains((CharSequence)charSequence, (CharSequence)string2, (boolean)true)) continue;
                mMimeTypeList.add(mimeType);
            }
        }
        return mMimeTypeList;
    }

    @NotNull
    public final FileTypes getCorrespondingFileType(int fileType) {
        FileTypes fileTypes;
        switch (fileType) {
            case 0: 
            case 1: {
                fileTypes = FileTypes.PICK_FILES;
                break;
            }
            case 2: {
                fileTypes = FileTypes.CAPTURE_IMAGE;
                break;
            }
            default: {
                fileTypes = FileTypes.PICK_FILES;
            }
        }
        return fileTypes;
    }

    public final int getCorrespondingRequestCode(int fileType) {
        int n;
        switch (fileType) {
            case 1: {
                n = 1996;
                break;
            }
            case 0: {
                n = 1995;
                break;
            }
            case 2: {
                n = 1001;
                break;
            }
            default: {
                n = 1996;
            }
        }
        return n;
    }

    @NotNull
    public final SelectionMode getCorrespondingFileSelectionMode(int selectionMode) {
        SelectionMode selectionMode2;
        switch (selectionMode) {
            case 0: {
                selectionMode2 = SelectionMode.SINGLE;
                break;
            }
            case 1: {
                selectionMode2 = SelectionMode.MULTIPLE;
                break;
            }
            default: {
                selectionMode2 = SelectionMode.SINGLE;
            }
        }
        return selectionMode2;
    }

    @NotNull
    public final AttachFileData convertFileDataToAttachFileData(@NotNull FileData fileData) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        return new AttachFileData(fileData.getUri(), fileData.getFilePath(), fileData.getFile(), fileData.getFileName(), fileData.getMimeType(), fileData.getFileSize(), false, 64, null);
    }

    @NotNull
    public final ArrayList<MimeType> getMimeTypesList() {
        return CollectionsKt.arrayListOf((Object[])new MimeType[]{MimeType.ALL_IMAGES, MimeType.JPEG, MimeType.PNG, MimeType.GIF, MimeType.BMP, MimeType.WEBP, MimeType.ALL_VIDEOS, MimeType.MPEG, MimeType.MP4, MimeType.GPP, MimeType.GPP2, MimeType.AVI, MimeType.TXT, MimeType.PDF, MimeType.DOC, MimeType.DOCX, MimeType.XLS, MimeType.XLSX, MimeType.PTT, MimeType.ALL_AUDIO, MimeType.PTTX, MimeType.MP3, MimeType.AUDIO_3GPP, MimeType.AUDIO_MP4, MimeType.AUDIO_AMR, MimeType.AUDIO_MIDI, MimeType.AUDIO_X_MIDI, MimeType.AUDIO_OGG, MimeType.AUDIO_WAV, MimeType.ALL_FILES});
    }

    public final double bytesToMegaBytes(@Nullable Double bytes) {
        return bytes != null ? bytes / (double)1000000 : 0.0;
    }

    public final boolean isValidAttachmentSize(double attachmentSize, int maxFileSize) {
        return this.bytesToMegaBytes(attachmentSize) <= (double)maxFileSize;
    }

    @Nullable
    public final Integer getCorrespondingAttachmentTypeIcon(@NotNull ArrayList<FileExtensionsData> fileExtensionsDataList, @NotNull AttachFileData fileData) {
        Intrinsics.checkNotNullParameter(fileExtensionsDataList, (String)"fileExtensionsDataList");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        for (MimeType mimeType : this.getMimeTypesList()) {
            String string2;
            if (fileData.getMimeType() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (!StringsKt.contains$default((CharSequence)mimeType.getMimeTypeName(), (CharSequence)it, (boolean)false, (int)2, null)) continue;
            if (mimeType == MimeType.ALL_IMAGES || mimeType == MimeType.JPEG || mimeType == MimeType.PNG || mimeType == MimeType.GIF || mimeType == MimeType.BMP || mimeType == MimeType.WEBP) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.IMAGE.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                continue;
            }
            if (mimeType == MimeType.MPEG || mimeType == MimeType.MP4 || mimeType == MimeType.GPP || mimeType == MimeType.GPP2 || mimeType == MimeType.AVI || mimeType == MimeType.ALL_VIDEOS) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.VIDEO.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                continue;
            }
            if (mimeType == MimeType.MP3 || mimeType == MimeType.AUDIO_3GPP || mimeType == MimeType.AUDIO_MP4 || mimeType == MimeType.AUDIO_AMR || mimeType == MimeType.AUDIO_MIDI || mimeType == MimeType.AUDIO_X_MIDI || mimeType == MimeType.AUDIO_OGG || mimeType == MimeType.AUDIO_WAV || mimeType == MimeType.ALL_AUDIO) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.AUDIO.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                continue;
            }
            if (mimeType == MimeType.DOC || mimeType == MimeType.DOCX) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.DOCS.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                continue;
            }
            if (mimeType == MimeType.PDF) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.PDF.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                continue;
            }
            if (mimeType == MimeType.TXT) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.PLAIN_TEXT.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                break;
            }
            if (mimeType == MimeType.PTT || mimeType == MimeType.PTTX) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.POWER_POINT.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                break;
            }
            if (mimeType == MimeType.XLS || mimeType == MimeType.XLSX) {
                for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                    Object object = fileExtensionsData.getFileExtensions();
                    if (object == null || (object = object.name()) == null) continue;
                    if (!((String)object).equals(FileExtensions.EXCEL.name())) continue;
                    return fileExtensionsData.getExtensionsIcon();
                }
                continue;
            }
            if (mimeType != MimeType.ALL_FILES) continue;
            for (FileExtensionsData fileExtensionsData : fileExtensionsDataList) {
                Object object = fileExtensionsData.getFileExtensions();
                if (object == null || (object = object.name()) == null) continue;
                if (!((String)object).equals(FileExtensions.ALL_FILES.name())) continue;
                return fileExtensionsData.getExtensionsIcon();
            }
        }
        return null;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

