/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.linkdev.fileattachmentview.view.mapper

import android.app.Activity
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment

/**
 * Caller is a mapper class to get context a based on caller is fragment or activity
 *  [fragment] for host fragment
 * [activity] for host activity
 */
class Caller private constructor(
    val fragment: Fragment? = null,
    val activity: AppCompatActivity? = null
) {
    companion object {
        fun getInstance(caller: Any): Caller {
            return when (caller) {
                is AppCompatActivity -> Caller(activity = caller)
                is Fragment -> Caller(fragment = caller)
                else -> throw(Throwable("please pass reference of androidx.appcompat.app.AppCompatActivity or androidx.fragment.app"))
            }
        }

        /**
         * Gets the [Caller] is fragment
         * [caller] reference to the caller fragment or activity
         */
        fun getCallerFragment(caller: Any): Fragment? {
            return if (getInstance(caller).fragment != null)
                getInstance(caller).fragment
            else
                null
        }

        /**
         * Gets the [Caller] is activity or not
         * [caller] reference to the caller fragment or activity
         */
        fun getCallerActivity(caller: Any): Activity? {
            return if (getInstance(caller).activity != null)
                getInstance(caller).activity
            else
                null
        }
    }


}