/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.linkdev.fileattachmentview.view.listeners

/**
 * interface to handle different permissions state
 */
interface IRequestPermissions {

    /**
     * Called after the permission granted
     */
    fun onPermissionGranted(permission: String)

    /**
     * Called right after the system permissions dialogs if the user checks "never ask again"
     *     on any of the requested permissions.
     */
    fun onNeverAskAgainChecked(permission: String)

    /**
     * Called when user denied the permission
     */

    fun onPermissionDenied(permission: String)


}