/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.linkdev.fileattachmentview.view.listeners

import com.linkdev.fileattachmentview.models.AttachFileData

/**
 * the consumer need to implement this interface to notified with different attachment actions
 */
interface IAttachFileClickListener {

    /**
     *  callback method used to notify the consumer when add attachment clicked
     */
    fun onAddAttachmentClicked()

    /**
     * callback method used to notify the consumer with delete attachment action
     */
    fun onDeleteAttachmentClicked(
        selectedFile: AttachFileData? = null
    )

}