/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.linkdev.fileattachmentview.utils

import android.content.Context
import android.content.DialogInterface
import android.graphics.Bitmap
import android.widget.ImageView
import android.widget.Toast
import androidx.appcompat.app.AlertDialog

/**
 * utils class for ui helper methods
 */
object UIUtils {
    /**
     * Call this method to show dialog
     * [context] current context
     * [title] title of the dialog
     * [message] message of the dialog
     * [positiveButton] positive button string
     * [negativeButton] negative button string
     * [cancelable] boolean indicate if the dialog is cancelable or not
     * [positiveClickListener] the click listener of the positive button
     * [negativeClickListener]the click listener of the negative button
     */
    fun showBasicDialog(
        context: Context, title: String? = null, message: String? = null,
        positiveButton: String, negativeButton: String? = null,
        cancelable: Boolean = true,
        positiveClickListener: DialogInterface.OnClickListener,
        negativeClickListener: DialogInterface.OnClickListener? = null
    ): AlertDialog {
        return AlertDialog.Builder(context)
            .setTitle(title)
            .setCancelable(cancelable)
            .setMessage(message)
            .setPositiveButton(positiveButton, positiveClickListener)
            .setNegativeButton(negativeButton, negativeClickListener)
            .show()
    }

    /**
     * Calls to display a toast message
     * [context] current context
     * [message] message that needed to display
     */
    fun showToast(context: Context?, message: String?) {
        Toast.makeText(context, message, Toast.LENGTH_LONG).show()
    }
}