/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.linkdev.fileattachmentview.utils

import android.util.Log
import com.linkdev.fileattachmentview.view.FileAttachmentView.Companion.TAG


/** this class used to log errors **/
object Logger {
    /** call this method if you need to log an error
     * [exceptionMessage] string indicates the exception error message that will throw
     *[logErrorMessage] string indicates the error message that needed to log
     */
    fun log(exceptionMessage: String, logErrorMessage: String?):Nothing {
        logErrorMessage?.let { Log.e(TAG, logErrorMessage )  }
        throw Exception(exceptionMessage)
    }
}