/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.linkdev.fileattachmentview.utils

/**
 * Constants object define different constants needed in the FileAttachmentView
 *
 */
object Constants {
    /**
     * request codes constant
     */
    object RequestCodes {
        const val REQUEST_APP_SETTINGS = 1000
        const val PICK_IMAGE = 1995
        const val PICK_FILE = 1996
        const val CAPTURE_IMAGE_REQUEST_CODE = 1001
    }

    /**
     * File types constant
     */
    object FileTypes {
        const val PICK_IMAGE = 0
        const val PICK_FILE = 1
        const val CAPTURE_IMAGE = 2
    }

    /**
     * file selection mode Constants
     */
    object SelectionMode {
        const val SINGLE = 0
        const val MULTIPLE = 1
    }

}