/*
 * Copyright (C) 2020 Link Development
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.linkdev.fileattachmentview.models

import android.net.Uri
import android.os.Parcelable
import androidx.annotation.Keep
import com.linkdev.filepicker.models.FileData
import kotlinx.parcelize.Parcelize
import java.io.File

@Keep
@Parcelize
/**
 * data class contains the attached file data
 */
data class AttachFileData(
    val uri: Uri? = null,
    val filePath: String? = null,
    val file: File? = null,
    val fileName: String? = null,
    val mimeType: String? = null,
    val fileSize: Double? = null,
    var isExceedMaxFile: Boolean = false
) : Parcelable {

    /**
     * convert the [AttachFileData] object to [FileData]
     */
    fun convertAttachFileDataToFileData(): FileData {
        return FileData(
            uri = uri,
            filePath = filePath,
            file = file,
            fileName = fileName,
            mimeType = mimeType,
            fileSize = fileSize
        )
    }
}
