/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.testing.junit;

import com.linecorp.armeria.client.BlockingWebClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.centraldogma.client.armeria.ArmeriaCentralDogmaBuilder;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.server.CentralDogma;
import com.linecorp.centraldogma.server.CentralDogmaBuilder;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.testing.internal.CentralDogmaRuleDelegate;
import com.linecorp.centraldogma.testing.internal.TemporaryFolder;
import com.linecorp.centraldogma.testing.junit.AbstractAllOrEachExtension;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CentralDogmaExtension
extends AbstractAllOrEachExtension {
    private final CentralDogmaRuleDelegate delegate;
    private final TemporaryFolder dataDir = new TemporaryFolder();

    public CentralDogmaExtension() {
        this(false);
    }

    public CentralDogmaExtension(boolean useTls) {
        this.delegate = new CentralDogmaRuleDelegate(useTls){

            protected void configure(CentralDogmaBuilder builder) {
                CentralDogmaExtension.this.configure(builder);
            }

            protected void configureClient(ArmeriaCentralDogmaBuilder builder) {
                CentralDogmaExtension.this.configureClient(builder);
            }

            protected void configureHttpClient(WebClientBuilder builder) {
                CentralDogmaExtension.this.configureHttpClient(builder);
            }

            protected void scaffold(com.linecorp.centraldogma.client.CentralDogma client) {
                CentralDogmaExtension.this.scaffold(client);
            }
        };
    }

    @Override
    public void before(ExtensionContext context) throws Exception {
        this.dataDir.create();
        this.delegate.setUp(this.dataDir.getRoot().toFile());
    }

    @Override
    public void after(ExtensionContext context) throws Exception {
        this.stopAsync().whenComplete((unused1, unused2) -> {
            try {
                this.dataDir.delete();
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    @UnstableApi
    public final Path dataDir() {
        return this.dataDir.getRoot();
    }

    public final void start() {
        this.startAsync().join();
    }

    public final CompletableFuture<Void> startAsync() {
        if (!this.dataDir.exists()) {
            try {
                this.dataDir.create();
            }
            catch (IOException e) {
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
            }
        }
        return this.delegate.startAsync(this.dataDir.getRoot().toFile());
    }

    public final void stop() {
        this.stopAsync().join();
    }

    public final CompletableFuture<Void> stopAsync() {
        return this.delegate.stopAsync();
    }

    public boolean useTls() {
        return this.delegate.useTls();
    }

    public final CentralDogma dogma() {
        return this.delegate.dogma();
    }

    public ProjectManager projectManager() {
        return this.delegate.projectManager();
    }

    public final MirroringService mirroringService() {
        return this.delegate.mirroringService();
    }

    public final com.linecorp.centraldogma.client.CentralDogma client() {
        return this.delegate.client();
    }

    public final WebClient httpClient() {
        return this.delegate.httpClient();
    }

    public final BlockingWebClient blockingHttpClient() {
        return this.delegate.blockingHttpClient();
    }

    public final InetSocketAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    protected void configure(CentralDogmaBuilder builder) {
    }

    protected void configureClient(ArmeriaCentralDogmaBuilder builder) {
    }

    protected void configureHttpClient(WebClientBuilder builder) {
    }

    protected void scaffold(com.linecorp.centraldogma.client.CentralDogma client) {
    }
}

