/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.testing.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class TemporaryFolder {
    @Nullable
    private Path root;

    public void create() throws IOException {
        this.root = Files.createTempDirectory("centraldogma", new FileAttribute[0]);
    }

    public boolean exists() {
        return this.root != null;
    }

    public Path getRoot() {
        if (this.root == null) {
            throw new IllegalStateException("The temporary folder has not been created yet");
        }
        return this.root;
    }

    public Path newFolder() throws IOException {
        return Files.createTempDirectory(this.getRoot(), "", new FileAttribute[0]);
    }

    public Path newFile() throws IOException {
        return Files.createTempFile(this.getRoot(), "", "", new FileAttribute[0]);
    }

    public void delete() throws IOException {
        if (this.root == null) {
            return;
        }
        try (Stream<Path> walk = Files.walk(this.root, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        this.root = null;
    }
}

