/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.testing.internal;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.centraldogma.client.armeria.AbstractArmeriaCentralDogmaBuilder;
import com.linecorp.centraldogma.client.armeria.ArmeriaCentralDogmaBuilder;
import com.linecorp.centraldogma.client.armeria.legacy.LegacyCentralDogmaBuilder;
import com.linecorp.centraldogma.server.CentralDogma;
import com.linecorp.centraldogma.server.CentralDogmaBuilder;
import com.linecorp.centraldogma.server.GracefulShutdownTimeout;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.TlsConfig;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.NetUtil;
import java.io.File;
import java.io.IOError;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class CentralDogmaRuleDelegate {
    private static final InetSocketAddress TEST_PORT = new InetSocketAddress(NetUtil.LOCALHOST4, 0);
    private final boolean useTls;
    @Nullable
    private volatile CentralDogma dogma;
    @Nullable
    private volatile com.linecorp.centraldogma.client.CentralDogma client;
    @Nullable
    private volatile com.linecorp.centraldogma.client.CentralDogma legacyClient;
    @Nullable
    private volatile WebClient webClient;
    @Nullable
    private volatile InetSocketAddress serverAddress;

    public CentralDogmaRuleDelegate(boolean useTls) {
        this.useTls = useTls;
    }

    public void setUp(File dataDir) {
        this.startAsync(dataDir).join();
        com.linecorp.centraldogma.client.CentralDogma client = this.client;
        assert (client != null);
        assert (this.legacyClient != null);
        this.scaffold(client);
    }

    public final CompletableFuture<Void> startAsync(File dataDir) {
        CentralDogma dogma;
        CentralDogmaBuilder builder = new CentralDogmaBuilder(dataDir).port(TEST_PORT, this.useTls ? SessionProtocol.HTTPS : SessionProtocol.HTTP).webAppEnabled(false).mirroringEnabled(false).gracefulShutdownTimeout(new GracefulShutdownTimeout(0L, 0L));
        if (this.useTls) {
            try {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                builder.tls(new TlsConfig(ssc.certificate(), ssc.privateKey(), null));
            }
            catch (Exception e) {
                Exceptions.throwUnsafely((Throwable)e);
            }
        }
        this.configure(builder);
        this.dogma = dogma = builder.build();
        return dogma.start().thenRun(() -> {
            InetSocketAddress serverAddress;
            ServerPort activePort = dogma.activePort();
            if (activePort == null) {
                return;
            }
            this.serverAddress = serverAddress = activePort.localAddress();
            ArmeriaCentralDogmaBuilder clientBuilder = new ArmeriaCentralDogmaBuilder();
            LegacyCentralDogmaBuilder legacyClientBuilder = new LegacyCentralDogmaBuilder();
            this.configureClientCommon((AbstractArmeriaCentralDogmaBuilder<?>)clientBuilder);
            this.configureClientCommon((AbstractArmeriaCentralDogmaBuilder<?>)legacyClientBuilder);
            this.configureClient(clientBuilder);
            this.configureClient(legacyClientBuilder);
            try {
                this.client = clientBuilder.build();
                this.legacyClient = legacyClientBuilder.build();
            }
            catch (UnknownHostException e) {
                throw new IOError(e);
            }
            String uri = "h2c://" + serverAddress.getHostString() + ':' + serverAddress.getPort();
            WebClientBuilder webClientBuilder = WebClient.builder((String)uri);
            this.configureHttpClient(webClientBuilder);
            this.webClient = webClientBuilder.build();
        });
    }

    public final CompletableFuture<Void> stopAsync() {
        CentralDogma dogma = this.dogma;
        this.dogma = null;
        if (dogma != null) {
            return dogma.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean useTls() {
        return this.useTls;
    }

    public final CentralDogma dogma() {
        CentralDogma dogma = this.dogma;
        if (dogma == null) {
            throw new IllegalStateException("Central Dogma not available");
        }
        return dogma;
    }

    public final MirroringService mirroringService() {
        return (MirroringService)this.dogma().mirroringService().get();
    }

    public final com.linecorp.centraldogma.client.CentralDogma client() {
        com.linecorp.centraldogma.client.CentralDogma client = this.client;
        if (client == null) {
            throw new IllegalStateException("Central Dogma client not available");
        }
        return client;
    }

    public final com.linecorp.centraldogma.client.CentralDogma legacyClient() {
        com.linecorp.centraldogma.client.CentralDogma legacyClient = this.legacyClient;
        if (legacyClient == null) {
            throw new IllegalStateException("Central Dogma not started");
        }
        return legacyClient;
    }

    public final WebClient httpClient() {
        WebClient webClient = this.webClient;
        if (webClient == null) {
            throw new IllegalStateException("Central Dogma not started");
        }
        return webClient;
    }

    public final InetSocketAddress serverAddress() {
        InetSocketAddress serverAddress = this.serverAddress;
        if (serverAddress == null) {
            throw new IllegalStateException("Central Dogma not started");
        }
        return serverAddress;
    }

    protected void configure(CentralDogmaBuilder builder) {
    }

    protected void configureClient(ArmeriaCentralDogmaBuilder builder) {
    }

    protected void configureClient(LegacyCentralDogmaBuilder builder) {
    }

    protected void configureHttpClient(WebClientBuilder builder) {
    }

    protected void scaffold(com.linecorp.centraldogma.client.CentralDogma client) {
    }

    private void configureClientCommon(AbstractArmeriaCentralDogmaBuilder<?> builder) {
        InetSocketAddress serverAddress = this.serverAddress;
        assert (serverAddress != null);
        builder.host(serverAddress.getHostString(), serverAddress.getPort());
        if (this.useTls) {
            builder.useTls();
            builder.clientFactory(ClientFactory.insecure());
        }
    }
}

