/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.project;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.ReadOnlyException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.linecorp.centraldogma.server.auth.SessionMasterKey;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionEntryExistsException;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionEntryNoExistException;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalProjectInitializer {
    private static final Logger logger = LoggerFactory.getLogger(InternalProjectInitializer.class);
    public static final String INTERNAL_PROJECT_DOGMA = "dogma";
    private final CommandExecutor executor;
    private final ProjectManager projectManager;
    private final EncryptionStorageManager encryptionStorageManager;
    private final CompletableFuture<Void> initialFuture = new CompletableFuture();
    @Nullable
    private volatile Revision lastTokensRevision;
    @Nullable
    private volatile Tokens tokens;

    public InternalProjectInitializer(CommandExecutor executor, ProjectManager projectManager, EncryptionStorageManager encryptionStorageManager) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.encryptionStorageManager = Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
    }

    public void initializeInReadOnlyMode() {
        try {
            if (!this.projectManager.exists(INTERNAL_PROJECT_DOGMA)) {
                throw new IllegalStateException("dogma project does not exist. Cannot initialize in read-only mode.");
            }
            Repository dogmaRepo = (Repository)((Project)this.projectManager.get(INTERNAL_PROJECT_DOGMA)).repos().get(INTERNAL_PROJECT_DOGMA);
            Entry entry = dogmaRepo.getOrNull(Revision.HEAD, Query.ofJson((String)"/tokens.json")).join();
            if (entry == null || !entry.hasContent()) {
                throw new IllegalStateException("/tokens.json file does not exist in dogma/dogma. Cannot initialize in read-only mode.");
            }
            this.setTokens(entry, dogmaRepo);
            if (this.encryptionStorageManager.encryptSessionCookie() && this.encryptionStorageManager.getCurrentSessionKey().join() == null) {
                throw new IllegalStateException("Session key does not exist. Cannot initialize in read-only mode.");
            }
            this.initialFuture.complete(null);
        }
        catch (Throwable t) {
            this.initialFuture.completeExceptionally(t);
            Exceptions.throwUnsafely((Throwable)t);
        }
    }

    public void initialize() {
        try {
            this.initialize0(INTERNAL_PROJECT_DOGMA);
            this.initializeTokens();
            this.initializeSessionKey();
            this.initialFuture.complete(null);
        }
        catch (Exception cause) {
            this.initialFuture.completeExceptionally(cause);
        }
    }

    public void initialize(String projectName) {
        Objects.requireNonNull(projectName, "projectName");
        Preconditions.checkArgument((!INTERNAL_PROJECT_DOGMA.equals(projectName) ? 1 : 0) != 0, (String)"Use initialize() to create %s", (Object)projectName);
        this.initialize0(projectName);
    }

    private void initialize0(String projectName) {
        long creationTimeMillis;
        block3: {
            creationTimeMillis = System.currentTimeMillis();
            if (!this.projectManager.exists(projectName)) {
                try {
                    this.executor.execute(Command.forcePush(Command.createProject(creationTimeMillis, Author.SYSTEM, projectName))).get();
                }
                catch (Throwable cause) {
                    Throwable peeled = Exceptions.peel((Throwable)cause);
                    if (peeled instanceof ProjectExistsException) break block3;
                    throw new Error("failed to initialize an internal project: " + projectName, peeled);
                }
            }
        }
        this.initializeInternalRepos(projectName, Project.internalRepos(), creationTimeMillis);
    }

    private void initializeTokens() {
        Repository dogmaRepo;
        block3: {
            dogmaRepo = (Repository)((Project)this.projectManager.get(INTERNAL_PROJECT_DOGMA)).repos().get(INTERNAL_PROJECT_DOGMA);
            Entry entry = dogmaRepo.getOrNull(Revision.HEAD, Query.ofJson((String)"/tokens.json")).join();
            if (entry != null && entry.hasContent()) {
                this.setTokens(entry, dogmaRepo);
                return;
            }
            try {
                Change change = Change.ofJsonPatch((String)"/tokens.json", null, (JsonNode)Jackson.valueToTree((Object)new Tokens()));
                String commitSummary = "Initialize the token list file: /dogma/dogma/tokens.json";
                this.executor.execute(Command.forcePush(Command.push(Author.SYSTEM, INTERNAL_PROJECT_DOGMA, INTERNAL_PROJECT_DOGMA, Revision.HEAD, "Initialize the token list file: /dogma/dogma/tokens.json", "", Markup.PLAINTEXT, ImmutableList.of((Object)change)))).get();
            }
            catch (Throwable cause) {
                Throwable peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof ChangeConflictException) break block3;
                throw new Error("failed to initialize the token list file", peeled);
            }
        }
        Entry entry1 = dogmaRepo.getOrNull(Revision.HEAD, Query.ofJson((String)"/tokens.json")).join();
        Preconditions.checkState((entry1 != null && entry1.hasContent() ? 1 : 0) != 0, (String)"%s file does not exist in %s/%s", (Object)"/tokens.json", (Object)INTERNAL_PROJECT_DOGMA, (Object)INTERNAL_PROJECT_DOGMA);
        this.setTokens(entry1, dogmaRepo);
    }

    private void setTokens(Entry<JsonNode> entry, Repository dogmaRepo) {
        try {
            Tokens tokens = (Tokens)Jackson.treeToValue((TreeNode)((TreeNode)entry.content()), Tokens.class);
            this.lastTokensRevision = entry.revision();
            this.tokens = tokens;
            this.attachTokensListener(dogmaRepo);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new RuntimeException(String.format("failed to parse %s/%s/%s", INTERNAL_PROJECT_DOGMA, INTERNAL_PROJECT_DOGMA, "/tokens.json"), e);
        }
    }

    private void attachTokensListener(Repository dogmaRepo) {
        dogmaRepo.addListener(RepositoryListener.of(Query.ofJson((String)"/tokens.json"), entry -> {
            if (entry == null) {
                logger.warn("{} file is missing in {}/{}", new Object[]{"/tokens.json", INTERNAL_PROJECT_DOGMA, INTERNAL_PROJECT_DOGMA});
                return;
            }
            Revision lastRevision = entry.revision();
            Revision lastTokensRevision = this.lastTokensRevision;
            if (lastTokensRevision != null && lastRevision.compareTo(lastTokensRevision) <= 0) {
                return;
            }
            try {
                Tokens tokens = (Tokens)Jackson.treeToValue((TreeNode)((TreeNode)entry.content()), Tokens.class);
                this.lastTokensRevision = lastRevision;
                this.tokens = tokens;
            }
            catch (JsonParseException | JsonMappingException e) {
                logger.warn("Invalid {} file in {}/{}", new Object[]{"/tokens.json", INTERNAL_PROJECT_DOGMA, INTERNAL_PROJECT_DOGMA, e});
            }
        }));
    }

    private void initializeSessionKey() {
        block7: {
            if (!this.encryptionStorageManager.encryptSessionCookie()) {
                return;
            }
            try {
                SessionKey sessionKey = this.encryptionStorageManager.getCurrentSessionKey().join();
                if (sessionKey != null) {
                    return;
                }
            }
            catch (Exception e) {
                Throwable peeled = Exceptions.peel((Throwable)e);
                if (peeled instanceof EncryptionEntryNoExistException) break block7;
                Exceptions.throwUnsafely((Throwable)peeled);
            }
        }
        SessionMasterKey sessionMasterKey = this.encryptionStorageManager.generateSessionMasterKey(1).join();
        try {
            this.executor.execute(Command.createSessionMasterKey(sessionMasterKey)).get();
        }
        catch (Throwable cause) {
            Throwable peeled = Exceptions.peel((Throwable)cause);
            if (peeled instanceof EncryptionEntryExistsException) {
                return;
            }
            throw new Error("failed to initialize a session master key", peeled);
        }
    }

    public CompletableFuture<Void> whenInitialized() {
        return this.initialFuture;
    }

    public Tokens tokens() {
        Tokens tokens = this.tokens;
        Preconditions.checkState((tokens != null ? 1 : 0) != 0, (Object)"tokens have not been loaded yet");
        return tokens;
    }

    private void initializeInternalRepos(String projectName, List<String> internalRepos, long creationTimeMillis) {
        Objects.requireNonNull(internalRepos, "internalRepos");
        Project project = (Project)this.projectManager.get(projectName);
        assert (project != null);
        for (String repo : internalRepos) {
            if (project.repos().exists(repo)) continue;
            try {
                this.executor.execute(Command.forcePush(Command.createRepository(creationTimeMillis, Author.SYSTEM, projectName, repo))).get();
            }
            catch (Throwable cause) {
                Throwable peeled = Exceptions.peel((Throwable)cause);
                if (peeled instanceof ReadOnlyException) {
                    return;
                }
                if (peeled instanceof RepositoryExistsException) continue;
                throw new Error("failed to initialize an internal repository: " + projectName + "/" + repo, peeled);
            }
        }
    }
}

