/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.encryption;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class WrappedDekDetails {
    private final String wrappedDek;
    private final int dekVersion;
    private final String kekId;
    private final String projectName;
    private final String repoName;
    private final String creation;
    private final Instant creationInstant;

    public WrappedDekDetails(String wrappedDek, int dekVersion, String kekId, String projectName, String repoName) {
        this(wrappedDek, dekVersion, kekId, Instant.now(), projectName, repoName);
    }

    @JsonCreator
    public WrappedDekDetails(@JsonProperty(value="wrappedDek") String wrappedDek, @JsonProperty(value="dekVersion") int dekVersion, @JsonProperty(value="kekId") String kekId, @JsonProperty(value="creation") Instant creation, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="repoName") String repoName) {
        this.wrappedDek = Objects.requireNonNull(wrappedDek, "wrappedDek");
        this.kekId = Objects.requireNonNull(kekId, "kekId");
        Preconditions.checkArgument((dekVersion > 0 ? 1 : 0) != 0, (String)"dekVersion must be positive: %s", (int)dekVersion);
        this.dekVersion = dekVersion;
        this.creationInstant = creation;
        this.creation = DateTimeFormatter.ISO_INSTANT.format(Objects.requireNonNull(creation, "creation"));
        this.projectName = Objects.requireNonNull(projectName, "projectName");
        this.repoName = Objects.requireNonNull(repoName, "repoName");
    }

    @JsonProperty
    public String wrappedDek() {
        return this.wrappedDek;
    }

    @JsonProperty
    public int dekVersion() {
        return this.dekVersion;
    }

    @JsonProperty
    public String kekId() {
        return this.kekId;
    }

    @JsonProperty
    public String creation() {
        return this.creation;
    }

    public Instant creationInstant() {
        return this.creationInstant;
    }

    @JsonProperty
    public String projectName() {
        return this.projectName;
    }

    @JsonProperty
    public String repoName() {
        return this.repoName;
    }

    public int hashCode() {
        int result = this.wrappedDek.hashCode();
        result = 31 * result + this.dekVersion;
        result = 31 * result + this.kekId.hashCode();
        result = 31 * result + this.creation.hashCode();
        result = 31 * result + this.projectName.hashCode();
        result = 31 * result + this.repoName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WrappedDekDetails)) {
            return false;
        }
        WrappedDekDetails that = (WrappedDekDetails)obj;
        return this.dekVersion == that.dekVersion && this.wrappedDek.equals(that.wrappedDek) && this.kekId.equals(that.kekId) && this.creation.equals(that.creation) && this.projectName.equals(that.projectName) && this.repoName.equals(that.repoName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("wrappedDek", (Object)"*****").add("dekVersion", this.dekVersion).add("kekId", (Object)this.kekId).add("creation", (Object)this.creation).add("projectName", (Object)this.projectName).add("repoName", (Object)this.repoName).toString();
    }
}

