/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.encryption;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.Snapshot;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RocksDBStorage {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBStorage.class);
    static final String WDEK_COLUMN_FAMILY = "wdek";
    static final String ENCRYPTION_METADATA_COLUMN_FAMILY = "encryption_metadata";
    static final String ENCRYPTED_OBJECT_COLUMN_FAMILY = "encrypted_object";
    static final String ENCRYPTED_OBJECT_ID_COLUMN_FAMILY = "encrypted_object_id";
    private static final List<String> ALL_COLUMN_FAMILY_NAMES = ImmutableList.of((Object)"default", (Object)"wdek", (Object)"encryption_metadata", (Object)"encrypted_object", (Object)"encrypted_object_id");
    private final RocksDB rocksDb;
    private final DBOptions dbOptions;
    private final Map<String, ColumnFamilyHandle> columnFamilyHandlesMap;
    private final BloomFilter bloomFilter;

    RocksDBStorage(String rocksDbPath) {
        RocksDB.loadLibrary();
        this.bloomFilter = new BloomFilter();
        HashMap<String, ColumnFamilyOptions> cfNameToOptions = new HashMap<String, ColumnFamilyOptions>();
        for (String string : ALL_COLUMN_FAMILY_NAMES) {
            cfNameToOptions.put(string, this.createColumnFamilyOptions(ENCRYPTION_METADATA_COLUMN_FAMILY.equals(string)));
        }
        ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        for (String cfName : ALL_COLUMN_FAMILY_NAMES) {
            cfDescriptors.add(new ColumnFamilyDescriptor(cfName.getBytes(StandardCharsets.UTF_8), (ColumnFamilyOptions)cfNameToOptions.get(cfName)));
        }
        this.dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
        ArrayList arrayList = new ArrayList();
        try {
            this.rocksDb = RocksDB.open((DBOptions)this.dbOptions, (String)rocksDbPath, cfDescriptors, arrayList);
        }
        catch (RocksDBException e) {
            this.bloomFilter.close();
            cfNameToOptions.values().forEach(AbstractImmutableNativeReference::close);
            this.dbOptions.close();
            throw new EncryptionStorageException("Failed to open RocksDB with column families at " + rocksDbPath, e);
        }
        ImmutableMap.Builder handlesMapBuilder = ImmutableMap.builder();
        for (ColumnFamilyHandle handle : arrayList) {
            try {
                handlesMapBuilder.put((Object)new String(handle.getName(), StandardCharsets.UTF_8), (Object)handle);
            }
            catch (RocksDBException e) {
                this.bloomFilter.close();
                arrayList.forEach(RocksDBStorage::closeSilently);
                RocksDBStorage.closeSilently((RocksObject)this.rocksDb);
                cfNameToOptions.values().forEach(AbstractImmutableNativeReference::close);
                this.dbOptions.close();
                throw new EncryptionStorageException("Failed to get name for a column family handle", e);
            }
        }
        this.columnFamilyHandlesMap = handlesMapBuilder.build();
        for (String cfName : ALL_COLUMN_FAMILY_NAMES) {
            if (this.columnFamilyHandlesMap.containsKey(cfName)) continue;
            this.close();
            throw new EncryptionStorageException("Column family handle not found for: " + cfName);
        }
    }

    private ColumnFamilyOptions createColumnFamilyOptions(boolean withBloomFilter) {
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions().setCompressionType(CompressionType.NO_COMPRESSION);
        if (!withBloomFilter) {
            return columnFamilyOptions;
        }
        return columnFamilyOptions.setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setFilterPolicy((Filter)this.bloomFilter));
    }

    @Nullable
    byte[] get(String cfName, byte[] key) throws RocksDBException {
        return this.rocksDb.get(this.getColumnFamilyHandle(cfName), key);
    }

    void write(WriteOptions writeOptions, WriteBatch writeBatch) throws RocksDBException {
        this.rocksDb.write(writeOptions, writeBatch);
    }

    RocksIterator newIterator(ColumnFamilyHandle cfHandle) {
        return this.rocksDb.newIterator(cfHandle);
    }

    RocksIterator newIterator(ColumnFamilyHandle cfHandle, ReadOptions readOptions) {
        return this.rocksDb.newIterator(cfHandle, readOptions);
    }

    ColumnFamilyHandle getColumnFamilyHandle(String cfName) {
        ColumnFamilyHandle handle = this.columnFamilyHandlesMap.get(cfName);
        if (handle == null) {
            throw new IllegalArgumentException("Column family not found: " + cfName);
        }
        return handle;
    }

    Map<String, ColumnFamilyHandle> getAllColumnFamilyHandles() {
        return this.columnFamilyHandlesMap;
    }

    Snapshot getSnapshot() {
        return this.rocksDb.getSnapshot();
    }

    void close() {
        this.bloomFilter.close();
        this.columnFamilyHandlesMap.values().forEach(RocksDBStorage::closeSilently);
        RocksDBStorage.closeSilently((RocksObject)this.rocksDb);
        RocksDBStorage.closeSilently((RocksObject)this.dbOptions);
    }

    private static void closeSilently(RocksObject obj) {
        try {
            obj.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close RocksObject silently", (Throwable)e);
        }
    }

    void releaseSnapshot(Snapshot snapshot) {
        this.rocksDb.releaseSnapshot(snapshot);
    }
}

