/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.encryption;

import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.EncryptionConfig;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.linecorp.centraldogma.server.auth.SessionMasterKey;
import com.linecorp.centraldogma.server.storage.encryption.DefaultEncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.NoopEncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.SecretKeyWithVersion;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;

public interface EncryptionStorageManager
extends SafeCloseable {
    public static EncryptionStorageManager of(CentralDogmaConfig cfg) {
        Objects.requireNonNull(cfg, "cfg");
        EncryptionConfig encryptionConfig = cfg.encryption();
        boolean enabled = encryptionConfig != null && encryptionConfig.enabled();
        Path rocksDbPath = cfg.dataDir().toPath().resolve("_rocks");
        if (!enabled) {
            if (rocksDbPath.toFile().exists()) {
                throw new IllegalArgumentException("RocksDB path exists but encryption is disabled.");
            }
            return NoopEncryptionStorageManager.INSTANCE;
        }
        String kekId = encryptionConfig.kekId();
        if (!1.$assertionsDisabled && kekId == null) {
            throw new AssertionError();
        }
        return new DefaultEncryptionStorageManager(rocksDbPath.toString(), encryptionConfig.encryptSessionCookie(), kekId);
    }

    @VisibleForTesting
    public static EncryptionStorageManager of(Path path, boolean encryptSessionCookie, String kekId) {
        Objects.requireNonNull(path, "path");
        return new DefaultEncryptionStorageManager(path.toString(), encryptSessionCookie, kekId);
    }

    public boolean enabled();

    public boolean encryptSessionCookie();

    public String kekId();

    public CompletableFuture<String> generateWdek();

    public CompletableFuture<SessionMasterKey> generateSessionMasterKey(int var1);

    public void storeSessionMasterKey(SessionMasterKey var1);

    public SessionMasterKey getCurrentSessionMasterKey();

    public CompletableFuture<SessionKey> getCurrentSessionKey();

    public CompletableFuture<SessionKey> getSessionKey(int var1);

    public void rotateSessionMasterKey(SessionMasterKey var1);

    public List<WrappedDekDetails> wdeks();

    public SecretKey getDek(String var1, String var2, int var3);

    public SecretKeyWithVersion getCurrentDek(String var1, String var2);

    public void storeWdek(WrappedDekDetails var1);

    public void rotateWdek(WrappedDekDetails var1);

    public void removeWdek(String var1, String var2, int var3, boolean var4);

    @Nullable
    public byte[] getObject(byte[] var1, byte[] var2);

    @Nullable
    public byte[] getObjectId(byte[] var1, byte[] var2);

    @Nullable
    public byte[] getMetadata(byte[] var1);

    public void putObject(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public void putObjectId(byte[] var1, byte[] var2, byte[] var3, byte[] var4, @Nullable byte[] var5);

    public boolean containsMetadata(byte[] var1);

    public void deleteObjectId(byte[] var1, byte[] var2);

    public void deleteRepositoryData(String var1, String var2);

    public void reencryptRepositoryData(String var1, String var2);

    @Deprecated
    public Map<String, Map<String, byte[]>> getAllData();

    public void addSessionKeyListener(Consumer<SessionKey> var1);

    public void addCurrentDekListener(String var1, String var2, Consumer<SecretKeyWithVersion> var3);

    public void removeCurrentDekListener(String var1, String var2);

    public CompletableFuture<Void> rewrapAllKeys(Executor var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

