/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;

public interface StorageManager<T> {
    public void close(Supplier<CentralDogmaException> var1);

    public boolean exists(String var1);

    public T get(String var1);

    default public T create(String name, Author author) {
        return this.create(name, System.currentTimeMillis(), author, false);
    }

    public T create(String var1, long var2, Author var4, boolean var5);

    public Map<String, T> list();

    public Map<String, Instant> listRemoved();

    public void remove(String var1);

    public T unremove(String var1);

    public void purgeMarked();

    public void markForPurge(String var1);

    public void ensureOpen();
}

