/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Objects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.metadata.ProjectRoles;
import com.linecorp.centraldogma.server.storage.repository.HasWeight;
import java.util.Map;

public final class Roles
implements HasWeight {
    static final Roles EMPTY = new Roles(ProjectRoles.of(null, null), (Map<String, RepositoryRole>)ImmutableMap.of(), (Map<String, RepositoryRole>)ImmutableMap.of());
    private final ProjectRoles projectRoles;
    private final Map<String, RepositoryRole> users;
    private final Map<String, RepositoryRole> tokens;

    @JsonCreator
    public Roles(@JsonProperty(value="projects") ProjectRoles projectRoles, @JsonProperty(value="users") Map<String, RepositoryRole> users, @JsonProperty(value="tokens") Map<String, RepositoryRole> tokens) {
        this.projectRoles = java.util.Objects.requireNonNull(projectRoles, "projectRoles");
        this.users = java.util.Objects.requireNonNull(users, "users");
        this.tokens = java.util.Objects.requireNonNull(tokens, "tokens");
    }

    @JsonProperty(value="projects")
    public ProjectRoles projectRoles() {
        return this.projectRoles;
    }

    @JsonProperty(value="users")
    public Map<String, RepositoryRole> users() {
        return this.users;
    }

    @JsonProperty(value="tokens")
    public Map<String, RepositoryRole> tokens() {
        return this.tokens;
    }

    @Override
    public int weight() {
        int weight = 0;
        RepositoryRole member = this.projectRoles.member();
        if (member != null) {
            weight += member.name().length();
        }
        for (Map.Entry<String, RepositoryRole> entry : this.users.entrySet()) {
            weight += entry.getKey().length();
            weight += entry.getValue().name().length();
        }
        for (Map.Entry<String, RepositoryRole> entry : this.tokens.entrySet()) {
            weight += entry.getKey().length();
            weight += entry.getValue().name().length();
        }
        return weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Roles)) {
            return false;
        }
        Roles other = (Roles)o;
        return this.projectRoles.equals(other.projectRoles) && this.users.equals(other.users) && this.tokens.equals(other.tokens);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectRoles, this.users, this.tokens});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectRoles", (Object)this.projectRoles).add("users", this.users).add("tokens", this.tokens).toString();
    }
}

