/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.RepositoryStatus;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchUtil;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadataTransformer;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.metadata.HolderWithRevision;
import com.linecorp.centraldogma.server.metadata.Member;
import com.linecorp.centraldogma.server.metadata.MemberNotFoundException;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.ProjectRoles;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadataTransformer;
import com.linecorp.centraldogma.server.metadata.RepositorySupport;
import com.linecorp.centraldogma.server.metadata.Roles;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.TokenNotFoundException;
import com.linecorp.centraldogma.server.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.metadata.TokensTransformer;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.metadata.UserWithToken;
import com.linecorp.centraldogma.server.storage.project.InternalProjectInitializer;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataService {
    private static final Logger logger = LoggerFactory.getLogger(MetadataService.class);
    public static final String METADATA_JSON = "/metadata.json";
    public static final String TOKEN_JSON = "/tokens.json";
    private static final JsonPointer PROJECT_REMOVAL = JsonPointer.compile((String)"/removal");
    private final ProjectManager projectManager;
    private final RepositorySupport<ProjectMetadata> metadataRepo;
    private final RepositorySupport<Tokens> tokenRepo;
    private final InternalProjectInitializer projectInitializer;
    private final Map<String, CompletableFuture<Revision>> reposInAddingMetadata = new ConcurrentHashMap<String, CompletableFuture<Revision>>();

    public MetadataService(ProjectManager projectManager, CommandExecutor executor, InternalProjectInitializer projectInitializer) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.projectInitializer = Objects.requireNonNull(projectInitializer, "projectInitializer");
        this.metadataRepo = new RepositorySupport<ProjectMetadata>(projectManager, executor, ProjectMetadata.class);
        this.tokenRepo = new RepositorySupport<Tokens>(projectManager, executor, Tokens.class);
    }

    public CompletableFuture<ProjectMetadata> getProject(String projectName) {
        Objects.requireNonNull(projectName, "projectName");
        return this.getOrFetchMetadata(projectName);
    }

    private CompletableFuture<ProjectMetadata> getOrFetchMetadata(String projectName) {
        ProjectMetadata metadata = this.getMetadata(projectName);
        Set<String> reposWithMetadata = metadata.repos().keySet();
        Set<String> repos = ((Project)this.projectManager.get(projectName)).repos().list().keySet();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String repo : repos) {
            CompletableFuture future;
            if (reposWithMetadata.contains(repo) || Project.isInternalRepo(repo)) continue;
            String projectAndRepositoryName = projectName + "/" + repo;
            CompletableFuture futureInMap = this.reposInAddingMetadata.computeIfAbsent(projectAndRepositoryName, arg_0 -> MetadataService.lambda$getOrFetchMetadata$0(future = new CompletableFuture(), arg_0));
            if (futureInMap != future) {
                builder.add((Object)futureInMap);
                continue;
            }
            logger.warn("Adding missing repository metadata: {}/{}", (Object)projectName, (Object)repo);
            Author author = ((Repository)((Project)this.projectManager.get(projectName)).repos().get(repo)).author();
            CompletableFuture<Revision> addRepoFuture = this.addRepo(author, projectName, repo);
            addRepoFuture.handle((revision, cause) -> {
                if (cause != null) {
                    future.completeExceptionally((Throwable)cause);
                } else {
                    future.complete(revision);
                }
                this.reposInAddingMetadata.remove(projectAndRepositoryName);
                return null;
            });
            builder.add(future);
        }
        ImmutableList futures = builder.build();
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(metadata);
        }
        return CompletableFutures.successfulAsList((List)futures, cause -> {
            Throwable peeled = Exceptions.peel((Throwable)cause);
            if (peeled instanceof RepositoryExistsException) {
                return null;
            }
            return (Revision)Exceptions.throwUnsafely((Throwable)cause);
        }).thenCompose(unused -> {
            logger.info("Fetching {}/{}{} again", new Object[]{projectName, "dogma", METADATA_JSON});
            return this.fetchMetadata(projectName);
        });
    }

    private ProjectMetadata getMetadata(String projectName) {
        Project project = (Project)this.projectManager.get(projectName);
        ProjectMetadata metadata = project.metadata();
        if (metadata == null) {
            throw new EntryNotFoundException("project metadata not found: " + projectName);
        }
        return metadata;
    }

    private CompletableFuture<ProjectMetadata> fetchMetadata(String projectName) {
        return this.metadataRepo.fetch(projectName, "dogma", METADATA_JSON).thenApply(HolderWithRevision::object);
    }

    public CompletableFuture<Revision> removeProject(Author author, String projectName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{JsonPatchOperation.testAbsence((JsonPointer)PROJECT_REMOVAL), JsonPatchOperation.add((JsonPointer)PROJECT_REMOVAL, (JsonNode)Jackson.valueToTree((Object)UserAndTimestamp.of(author)))}));
        return this.metadataRepo.push(projectName, "dogma", author, "Remove the project: " + projectName, change);
    }

    public CompletableFuture<Revision> restoreProject(Author author, String projectName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.remove((JsonPointer)PROJECT_REMOVAL).toJsonNode());
        return this.metadataRepo.push(projectName, "dogma", author, "Restore the project: " + projectName, change);
    }

    public CompletableFuture<Member> getMember(String projectName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(user, "user");
        return this.getProject(projectName).thenApply(project -> project.memberOrDefault(user.id(), null));
    }

    public CompletableFuture<Revision> addMember(Author author, String projectName, User member, ProjectRole projectRole) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(projectRole, "projectRole");
        Member newMember = new Member(member, projectRole, UserAndTimestamp.of(author));
        JsonPointer path = JsonPointer.compile((String)("/members" + JsonPatchUtil.encodeSegment((String)newMember.id())));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{JsonPatchOperation.testAbsence((JsonPointer)path), JsonPatchOperation.add((JsonPointer)path, (JsonNode)Jackson.valueToTree((Object)newMember))}));
        String commitSummary = "Add a member '" + newMember.id() + "' to the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> removeMember(Author author, String projectName, User user) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(user, "user");
        String memberId = user.id();
        String commitSummary = "Remove the member '" + memberId + "' from the project '" + projectName + "'";
        ProjectMetadataTransformer transformer = new ProjectMetadataTransformer((headRevision, projectMetadata) -> {
            projectMetadata.member(memberId);
            ImmutableMap<String, Member> newMembers = MetadataService.removeFromMap(projectMetadata.members(), memberId);
            ImmutableMap<String, RepositoryMetadata> newRepos = MetadataService.removeMemberFromRepositories(projectMetadata, memberId);
            return new ProjectMetadata(projectMetadata.name(), (Map<String, RepositoryMetadata>)newRepos, (Map<String, Member>)newMembers, projectMetadata.tokens(), projectMetadata.creation(), projectMetadata.removal());
        });
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    private static ImmutableMap<String, RepositoryMetadata> removeMemberFromRepositories(ProjectMetadata projectMetadata, String memberId) {
        ImmutableMap.Builder reposBuilder = ImmutableMap.builderWithExpectedSize((int)projectMetadata.repos().size());
        for (Map.Entry<String, RepositoryMetadata> entry : projectMetadata.repos().entrySet()) {
            RepositoryMetadata repositoryMetadata = entry.getValue();
            Roles roles = repositoryMetadata.roles();
            Map<String, RepositoryRole> users = roles.users();
            if (users.get(memberId) != null) {
                ImmutableMap<String, RepositoryRole> newUsers = MetadataService.removeFromMap(users, memberId);
                Roles newRoles = new Roles(roles.projectRoles(), (Map<String, RepositoryRole>)newUsers, roles.tokens());
                reposBuilder.put((Object)entry.getKey(), (Object)new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status()));
                continue;
            }
            reposBuilder.put(entry);
        }
        return reposBuilder.build();
    }

    public CompletableFuture<Revision> updateMemberRole(Author author, String projectName, User member, ProjectRole projectRole) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(projectRole, "projectRole");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.replace((JsonPointer)JsonPointer.compile((String)("/members" + JsonPatchUtil.encodeSegment((String)member.id()) + "/role")), (JsonNode)Jackson.valueToTree((Object)projectRole)).toJsonNode());
        String commitSummary = "Updates the role of the member '" + member.id() + "' as '" + String.valueOf(projectRole) + "' for the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<RepositoryMetadata> getRepo(String projectName, String repoName) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        return this.getProject(projectName).thenApply(project -> project.repo(repoName));
    }

    public CompletableFuture<Revision> addRepo(Author author, String projectName, String repoName) {
        return this.addRepo(author, projectName, repoName, RepositoryMetadata.DEFAULT_PROJECT_ROLES);
    }

    public CompletableFuture<Revision> addRepo(Author author, String projectName, String repoName, ProjectRoles projectRoles) {
        return this.addRepo(author, projectName, repoName, RepositoryMetadata.of(repoName, UserAndTimestamp.of(author), projectRoles));
    }

    public CompletableFuture<Revision> addRepo(Author author, String projectName, String repoName, RepositoryMetadata repositoryMetadata) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(repositoryMetadata, "repositoryMetadata");
        JsonPointer path = JsonPointer.compile((String)("/repos" + JsonPatchUtil.encodeSegment((String)repoName)));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{JsonPatchOperation.testAbsence((JsonPointer)path), JsonPatchOperation.add((JsonPointer)path, (JsonNode)Jackson.valueToTree((Object)repositoryMetadata))}));
        String commitSummary = "Add a repo '" + repositoryMetadata.id() + "' to the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change).handle((revision, cause) -> {
            if (cause != null) {
                if (Exceptions.peel((Throwable)cause) instanceof ChangeConflictException) {
                    throw RepositoryExistsException.of((String)projectName, (String)repoName);
                }
                return (Revision)Exceptions.throwUnsafely((Throwable)cause);
            }
            return revision;
        });
    }

    public CompletableFuture<Revision> removeRepo(Author author, String projectName, String repoName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        JsonPointer path = JsonPointer.compile((String)("/repos" + JsonPatchUtil.encodeSegment((String)repoName) + "/removal"));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{JsonPatchOperation.testAbsence((JsonPointer)path), JsonPatchOperation.add((JsonPointer)path, (JsonNode)Jackson.valueToTree((Object)UserAndTimestamp.of(author)))}));
        String commitSummary = "Remove the repo '" + repoName + "' from the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> purgeRepo(Author author, String projectName, String repoName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        JsonPointer path = JsonPointer.compile((String)("/repos" + JsonPatchUtil.encodeSegment((String)repoName)));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.remove((JsonPointer)path).toJsonNode());
        String commitSummary = "Purge the repo '" + repoName + "' from the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> restoreRepo(Author author, String projectName, String repoName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.remove((JsonPointer)JsonPointer.compile((String)("/repos" + JsonPatchUtil.encodeSegment((String)repoName) + "/removal"))).toJsonNode());
        String commitSummary = "Restore the repo '" + repoName + "' from the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> updateRepositoryProjectRoles(Author author, String projectName, String repoName, ProjectRoles projectRoles) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        if (Project.isInternalRepo(repoName)) {
            throw new UnsupportedOperationException("Can't update role for internal repository: " + repoName);
        }
        String commitSummary = "Update the project roles of the '" + repoName + "' in the project '" + projectName + "'";
        RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
            Roles newRoles = new Roles(projectRoles, repositoryMetadata.roles().users(), repositoryMetadata.roles().tokens());
            return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
        });
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<Revision> addToken(Author author, String projectName, Token token, ProjectRole role) {
        return this.addToken(author, projectName, Objects.requireNonNull(token, "token").appId(), role);
    }

    public CompletableFuture<Revision> addToken(Author author, String projectName, String appId, ProjectRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(role, "role");
        this.getTokens().get(appId);
        TokenRegistration registration = new TokenRegistration(appId, role, UserAndTimestamp.of(author));
        JsonPointer path = JsonPointer.compile((String)("/tokens" + JsonPatchUtil.encodeSegment((String)registration.id())));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{JsonPatchOperation.testAbsence((JsonPointer)path), JsonPatchOperation.add((JsonPointer)path, (JsonNode)Jackson.valueToTree((Object)registration))}));
        String commitSummary = "Add a token '" + registration.id() + "' to the project '" + projectName + "' with a role '" + String.valueOf(role) + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> removeToken(Author author, String projectName, Token token) {
        return this.removeToken(author, projectName, Objects.requireNonNull(token, "token").appId());
    }

    public CompletableFuture<Revision> removeToken(Author author, String projectName, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(appId, "appId");
        return this.removeToken(projectName, author, appId, false);
    }

    private CompletableFuture<Revision> removeToken(String projectName, Author author, String appId, boolean quiet) {
        String commitSummary = "Remove the token '" + appId + "' from the project '" + projectName + "'";
        ProjectMetadataTransformer transformer = new ProjectMetadataTransformer((headRevision, projectMetadata) -> {
            Map newTokens;
            Map tokens = projectMetadata.tokens();
            if (tokens.get(appId) == null) {
                if (!quiet) {
                    throw new TokenNotFoundException("failed to find the token " + appId + " in project " + projectName);
                }
                newTokens = tokens;
            } else {
                newTokens = (Map)tokens.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(appId)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            ImmutableMap<String, RepositoryMetadata> newRepos = MetadataService.removeTokenFromRepositories(appId, projectMetadata);
            return new ProjectMetadata(projectMetadata.name(), (Map<String, RepositoryMetadata>)newRepos, projectMetadata.members(), newTokens, projectMetadata.creation(), projectMetadata.removal());
        });
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    private static ImmutableMap<String, RepositoryMetadata> removeTokenFromRepositories(String appId, ProjectMetadata projectMetadata) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)projectMetadata.repos().size());
        for (Map.Entry<String, RepositoryMetadata> entry : projectMetadata.repos().entrySet()) {
            RepositoryMetadata repositoryMetadata = entry.getValue();
            Roles roles = repositoryMetadata.roles();
            if (roles.tokens().get(appId) != null) {
                ImmutableMap<String, RepositoryRole> newTokens = MetadataService.removeFromMap(roles.tokens(), appId);
                Roles newRoles = new Roles(roles.projectRoles(), roles.users(), (Map<String, RepositoryRole>)newTokens);
                builder.put((Object)entry.getKey(), (Object)new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status()));
                continue;
            }
            builder.put(entry);
        }
        return builder.build();
    }

    public CompletableFuture<Revision> updateTokenRole(Author author, String projectName, Token token, ProjectRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(role, "role");
        TokenRegistration registration = new TokenRegistration(token.appId(), role, UserAndTimestamp.of(author));
        JsonPointer path = JsonPointer.compile((String)("/tokens" + JsonPatchUtil.encodeSegment((String)registration.id())));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.replace((JsonPointer)path, (JsonNode)Jackson.valueToTree((Object)registration)).toJsonNode());
        String commitSummary = "Update the role of a token '" + token.appId() + "' as '" + String.valueOf(role) + "' for the project '" + projectName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> addUserRepositoryRole(Author author, String projectName, String repoName, User member, RepositoryRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(role, "role");
        return this.getProject(projectName).thenCompose(project -> {
            project.repo(repoName);
            MetadataService.ensureProjectMember(project, member);
            String commitSummary = "Add repository role of '" + member.id() + "' as '" + String.valueOf(role) + "' to '" + projectName + "/" + repoName + "\n";
            RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
                Roles roles = repositoryMetadata.roles();
                if (roles.users().get(member.id()) != null) {
                    throw new ChangeConflictException("the member " + member.id() + " is already added to '" + projectName + "/" + repoName + "'");
                }
                Map<String, RepositoryRole> users = roles.users();
                ImmutableMap<String, RepositoryRole> newUsers = MetadataService.addToMap(users, member.id(), role);
                Roles newRoles = new Roles(roles.projectRoles(), (Map<String, RepositoryRole>)newUsers, roles.tokens());
                return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
            });
            return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
        });
    }

    public CompletableFuture<Revision> removeUserRepositoryRole(Author author, String projectName, String repoName, User member) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(member, "member");
        String memberId = member.id();
        RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
            Roles roles = repositoryMetadata.roles();
            if (roles.users().get(memberId) == null) {
                throw new MemberNotFoundException(memberId, projectName, repoName);
            }
            ImmutableMap<String, RepositoryRole> newUsers = MetadataService.removeFromMap(roles.users(), memberId);
            Roles newRoles = new Roles(roles.projectRoles(), (Map<String, RepositoryRole>)newUsers, roles.tokens());
            return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
        });
        String commitSummary = "Remove repository role of the '" + memberId + "' from '" + projectName + "/" + repoName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<Revision> updateUserRepositoryRole(Author author, String projectName, String repoName, User member, RepositoryRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(role, "role");
        String memberId = member.id();
        RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
            Roles roles = repositoryMetadata.roles();
            RepositoryRole oldRepositoryRole = roles.users().get(memberId);
            if (oldRepositoryRole == null) {
                throw new MemberNotFoundException(memberId, projectName, repoName);
            }
            if (oldRepositoryRole == role) {
                throw new RedundantChangeException(headRevision, "the repository role of " + memberId + " in '" + projectName + "/" + repoName + "' isn't changed.");
            }
            Map<String, RepositoryRole> newUsers = MetadataService.updateMap(roles.users(), memberId, role);
            Roles newRoles = new Roles(roles.projectRoles(), newUsers, roles.tokens());
            return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
        });
        String commitSummary = "Update repository role of the '" + memberId + "' as '" + String.valueOf(role) + "' for '" + projectName + "/" + repoName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<Revision> addTokenRepositoryRole(Author author, String projectName, String repoName, String appId, RepositoryRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(role, "role");
        return this.getProject(projectName).thenCompose(project -> {
            project.repo(repoName);
            MetadataService.ensureProjectToken(project, appId);
            String commitSummary = "Add repository role of the token '" + appId + "' as '" + String.valueOf(role) + "' to '" + projectName + "/" + repoName + "'\n";
            RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
                Roles roles = repositoryMetadata.roles();
                if (roles.tokens().get(appId) != null) {
                    throw new ChangeConflictException("the token " + appId + " is already added to '" + projectName + "/" + repoName + "'");
                }
                ImmutableMap<String, RepositoryRole> newTokens = MetadataService.addToMap(roles.tokens(), appId, role);
                Roles newRoles = new Roles(roles.projectRoles(), roles.users(), (Map<String, RepositoryRole>)newTokens);
                return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
            });
            return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
        });
    }

    public CompletableFuture<Revision> removeTokenRepositoryRole(Author author, String projectName, String repoName, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
            Roles roles = repositoryMetadata.roles();
            if (roles.tokens().get(appId) == null) {
                throw new ChangeConflictException("the token " + appId + " doesn't exist at '" + projectName + "/" + repoName + "'");
            }
            ImmutableMap<String, RepositoryRole> newTokens = MetadataService.removeFromMap(roles.tokens(), appId);
            Roles newRoles = new Roles(roles.projectRoles(), roles.users(), (Map<String, RepositoryRole>)newTokens);
            return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
        });
        String commitSummary = "Remove repository role of the token '" + appId + "' from '" + projectName + "/" + repoName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<Revision> updateTokenRepositoryRole(Author author, String projectName, String repoName, String appId, RepositoryRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(role, "role");
        RepositoryMetadataTransformer transformer = new RepositoryMetadataTransformer(repoName, (headRevision, repositoryMetadata) -> {
            Roles roles = repositoryMetadata.roles();
            RepositoryRole oldRepositoryRole = roles.tokens().get(appId);
            if (oldRepositoryRole == null) {
                throw new TokenNotFoundException("the token " + appId + " doesn't exist at '" + projectName + "/" + repoName + "'");
            }
            if (oldRepositoryRole == role) {
                throw new RedundantChangeException(headRevision, "the permission of " + appId + " in '" + projectName + "/" + repoName + "' isn't changed.");
            }
            Map<String, RepositoryRole> newTokens = MetadataService.updateMap(roles.tokens(), appId, role);
            Roles newRoles = new Roles(roles.projectRoles(), roles.users(), newTokens);
            return new RepositoryMetadata(repositoryMetadata.name(), newRoles, repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryMetadata.status());
        });
        String commitSummary = "Update repository role of the token '" + appId + "' for '" + projectName + "/" + repoName + "'";
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<RepositoryRole> findRepositoryRole(String projectName, String repoName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(user, "user");
        if (user.isSystemAdmin()) {
            return CompletableFuture.completedFuture(RepositoryRole.ADMIN);
        }
        if (user instanceof UserWithToken) {
            return this.findRepositoryRole(projectName, repoName, ((UserWithToken)user).token());
        }
        return this.findRepositoryRole0(projectName, repoName, user);
    }

    public CompletableFuture<RepositoryRole> findRepositoryRole(String projectName, String repoName, Token token) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(token, "token");
        return this.getProject(projectName).thenApply(metadata -> {
            ProjectRole projectRole;
            RepositoryMetadata repositoryMetadata = metadata.repo(repoName);
            Roles roles = repositoryMetadata.roles();
            String appId = token.appId();
            RepositoryRole tokenRepositoryRole = roles.tokens().get(appId);
            TokenRegistration projectTokenRegistration = metadata.tokens().get(appId);
            if (projectTokenRegistration != null) {
                projectRole = projectTokenRegistration.role();
            } else {
                assert (!token.isSystemAdmin());
                if (token.allowGuestAccess()) {
                    projectRole = ProjectRole.GUEST;
                } else {
                    return null;
                }
            }
            return MetadataService.repositoryRole(roles, tokenRepositoryRole, projectRole);
        });
    }

    private CompletableFuture<RepositoryRole> findRepositoryRole0(String projectName, String repoName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(user, "user");
        return this.getProject(projectName).thenApply(metadata -> {
            RepositoryMetadata repositoryMetadata = metadata.repo(repoName);
            Roles roles = repositoryMetadata.roles();
            RepositoryRole userRepositoryRole = roles.users().get(user.id());
            Member projectUser = metadata.memberOrDefault(user.id(), null);
            ProjectRole projectRole = projectUser != null ? projectUser.role() : ProjectRole.GUEST;
            return MetadataService.repositoryRole(roles, userRepositoryRole, projectRole);
        });
    }

    @Nullable
    private static RepositoryRole repositoryRole(Roles roles, @Nullable RepositoryRole repositoryRole, ProjectRole projectRole) {
        RepositoryRole memberOrGuestRole;
        if (projectRole == ProjectRole.OWNER) {
            return RepositoryRole.ADMIN;
        }
        if (projectRole == ProjectRole.MEMBER) {
            memberOrGuestRole = roles.projectRoles().member();
        } else {
            assert (projectRole == ProjectRole.GUEST);
            memberOrGuestRole = roles.projectRoles().guest();
        }
        if (repositoryRole == RepositoryRole.ADMIN || memberOrGuestRole == RepositoryRole.ADMIN) {
            return RepositoryRole.ADMIN;
        }
        if (repositoryRole == RepositoryRole.WRITE || memberOrGuestRole == RepositoryRole.WRITE) {
            return RepositoryRole.WRITE;
        }
        if (repositoryRole == RepositoryRole.READ || memberOrGuestRole == RepositoryRole.READ) {
            return RepositoryRole.READ;
        }
        return null;
    }

    public CompletableFuture<ProjectRole> findProjectRole(String projectName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(user, "user");
        if (user.isSystemAdmin()) {
            return CompletableFuture.completedFuture(ProjectRole.OWNER);
        }
        return this.getProject(projectName).thenApply(project -> {
            if (user instanceof UserWithToken) {
                TokenRegistration registration = project.tokens().getOrDefault(((UserWithToken)user).token().id(), null);
                return registration != null ? registration.role() : ProjectRole.GUEST;
            }
            Member member = project.memberOrDefault(user.id(), null);
            return member != null ? member.role() : ProjectRole.GUEST;
        });
    }

    public CompletableFuture<Tokens> fetchTokens() {
        return this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(HolderWithRevision::object);
    }

    public Tokens getTokens() {
        return this.projectInitializer.tokens();
    }

    public CompletableFuture<Revision> createToken(Author author, String appId) {
        return this.createToken(author, appId, false);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId, boolean isSystemAdmin) {
        return this.createToken(author, appId, "appToken-" + String.valueOf(UUID.randomUUID()), isSystemAdmin);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId, String secret) {
        return this.createToken(author, appId, secret, false);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId, String secret, boolean isSystemAdmin) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(secret, "secret");
        Preconditions.checkArgument((boolean)secret.startsWith("appToken-"), (Object)"secret must start with: appToken-");
        boolean allowGuestAccess = isSystemAdmin;
        Token newToken = new Token(appId, secret, isSystemAdmin, allowGuestAccess, UserAndTimestamp.of(author));
        JsonPointer appIdPath = JsonPointer.compile((String)("/appIds" + JsonPatchUtil.encodeSegment((String)newToken.id())));
        String newTokenSecret = newToken.secret();
        assert (newTokenSecret != null);
        JsonPointer secretPath = JsonPointer.compile((String)("/secrets" + JsonPatchUtil.encodeSegment((String)newTokenSecret)));
        Change change = Change.ofJsonPatch((String)TOKEN_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{JsonPatchOperation.testAbsence((JsonPointer)appIdPath), JsonPatchOperation.testAbsence((JsonPointer)secretPath), JsonPatchOperation.add((JsonPointer)appIdPath, (JsonNode)Jackson.valueToTree((Object)newToken)), JsonPatchOperation.add((JsonPointer)secretPath, (JsonNode)Jackson.valueToTree((Object)newToken.id()))}));
        return this.tokenRepo.push("dogma", "dogma", author, "Add a token: " + newToken.id(), change);
    }

    public CompletableFuture<Revision> destroyToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        String commitSummary = "Destroy the token: " + appId;
        UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
        TokensTransformer transformer = new TokensTransformer((headRevision, tokens) -> {
            Token token = tokens.get(appId);
            if (token.deletion() != null) {
                throw new ChangeConflictException("The token is already destroyed: " + appId);
            }
            String secret = token.secret();
            assert (secret != null);
            Token newToken = new Token(token.appId(), secret, token.isSystemAdmin(), token.isSystemAdmin(), token.allowGuestAccess(), token.creation(), token.deactivation(), userAndTimestamp);
            return new Tokens(MetadataService.updateMap(tokens.appIds(), appId, newToken), tokens.secrets());
        });
        return this.tokenRepo.push("dogma", "dogma", author, commitSummary, transformer);
    }

    public Revision purgeToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        Collection<Project> projects = ProjectApiManager.listProjectsWithoutInternal(this.projectManager.list(), User.SYSTEM_ADMIN).values();
        for (Project project : projects) {
            ProjectMetadata projectMetadata = this.fetchMetadata(project.name()).join();
            boolean containsTargetTokenInTheProject = projectMetadata.tokens().values().stream().anyMatch(token -> token.appId().equals(appId));
            if (!containsTargetTokenInTheProject) continue;
            this.removeToken(project.name(), author, appId, true).join();
        }
        String commitSummary = "Remove the token: " + appId;
        TokensTransformer transformer = new TokensTransformer((headRevision, tokens) -> {
            Token token = tokens.get(appId);
            ImmutableMap<String, Token> newAppIds = MetadataService.removeFromMap(tokens.appIds(), appId);
            String secret = token.secret();
            assert (secret != null);
            ImmutableMap<String, String> newSecrets = MetadataService.removeFromMap(tokens.secrets(), secret);
            return new Tokens((Map<String, Token>)newAppIds, (Map<String, String>)newSecrets);
        });
        return this.tokenRepo.push("dogma", "dogma", author, commitSummary, transformer).join();
    }

    public CompletableFuture<Revision> activateToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        String commitSummary = "Enable the token: " + appId;
        TokensTransformer transformer = new TokensTransformer((headRevision, tokens) -> {
            Token token = tokens.get(appId);
            if (token.deactivation() == null) {
                throw new RedundantChangeException(headRevision, "The token is already activated: " + appId);
            }
            String secret = token.secret();
            assert (secret != null);
            ImmutableMap<String, String> newSecrets = MetadataService.addToMap(tokens.secrets(), secret, appId);
            Token newToken = new Token(token.appId(), secret, token.isSystemAdmin(), token.allowGuestAccess(), token.creation());
            return new Tokens(MetadataService.updateMap(tokens.appIds(), appId, newToken), (Map<String, String>)newSecrets);
        });
        return this.tokenRepo.push("dogma", "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<Revision> deactivateToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        String commitSummary = "Deactivate the token: " + appId;
        UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
        TokensTransformer transformer = new TokensTransformer((headRevision, tokens) -> {
            Token token = tokens.get(appId);
            if (token.deactivation() != null) {
                throw new RedundantChangeException(headRevision, "The token is already deactivated: " + appId);
            }
            String secret = token.secret();
            assert (secret != null);
            Token newToken = new Token(token.appId(), secret, token.isSystemAdmin(), token.isSystemAdmin(), token.allowGuestAccess(), token.creation(), userAndTimestamp, null);
            Map<String, Token> newAppIds = MetadataService.updateMap(tokens.appIds(), appId, newToken);
            ImmutableMap<String, String> newSecrets = MetadataService.removeFromMap(tokens.secrets(), secret);
            return new Tokens(newAppIds, (Map<String, String>)newSecrets);
        });
        return this.tokenRepo.push("dogma", "dogma", author, commitSummary, transformer);
    }

    public CompletableFuture<Revision> updateTokenLevel(Author author, String appId, boolean toBeSystemAdmin) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        String commitSummary = "Update the token level: " + appId + " to " + (toBeSystemAdmin ? "admin" : "user");
        TokensTransformer transformer = new TokensTransformer((headRevision, tokens) -> {
            Token token = tokens.get(appId);
            if (toBeSystemAdmin == token.isSystemAdmin()) {
                throw new RedundantChangeException(headRevision, "The token is already " + (toBeSystemAdmin ? "admin" : "user"));
            }
            Token newToken = token.withSystemAdmin(toBeSystemAdmin);
            return new Tokens(MetadataService.updateMap(tokens.appIds(), appId, newToken), tokens.secrets());
        });
        return this.tokenRepo.push("dogma", "dogma", author, commitSummary, transformer);
    }

    public Token findTokenByAppId(String appId) {
        Objects.requireNonNull(appId, "appId");
        return this.getTokens().get(appId);
    }

    public Token findTokenBySecret(String secret) {
        Objects.requireNonNull(secret, "secret");
        Tokens.validateSecret(secret);
        return this.getTokens().findBySecret(secret);
    }

    private static void ensureProjectMember(ProjectMetadata project, User user) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(user, "user");
        if (project.members().values().stream().noneMatch(member -> member.login().equals(user.id()))) {
            throw new MemberNotFoundException(user.id(), project.name());
        }
    }

    private static void ensureProjectToken(ProjectMetadata project, String appId) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(appId, "appId");
        if (!project.tokens().containsKey(appId)) {
            throw new TokenNotFoundException(appId + " is not a token of the project '" + project.name() + "'");
        }
    }

    private static <T> ImmutableMap<String, T> addToMap(Map<String, T> map, String key, T value) {
        return ImmutableMap.builderWithExpectedSize((int)(map.size() + 1)).putAll(map).put((Object)key, value).build();
    }

    private static <T> Map<String, T> updateMap(Map<String, T> map, String key, T value) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (entry.getKey().equals(key)) {
                builder.put((Object)key, value);
                continue;
            }
            builder.put(entry);
        }
        return builder.build();
    }

    private static <T> ImmutableMap<String, T> removeFromMap(Map<String, T> map, String id) {
        return (ImmutableMap)map.entrySet().stream().filter(e -> !((String)e.getKey()).equals(id)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public CompletableFuture<Revision> updateRepositoryStatus(Author author, String projectName, String repoName, RepositoryStatus repositoryStatus) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(repositoryStatus, "repositoryStatus");
        String newRepoName = "meta".equals(repoName) ? "dogma" : repoName;
        ProjectMetadataTransformer transformer = "dogma".equals(newRepoName) ? new ProjectMetadataTransformer((headRevision, projectMetadata) -> {
            RepositoryMetadata repositoryMetadata = projectMetadata.repos().get("dogma");
            if (repositoryMetadata != null) {
                MetadataService.throwIfRedundant(repositoryStatus, headRevision, repositoryMetadata, "dogma");
            }
            RepositoryMetadata newRepositoryMetadata = RepositoryMetadata.ofDogma(repositoryStatus);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"dogma", (Object)newRepositoryMetadata);
            projectMetadata.repos().forEach((name, metadata) -> {
                if (!"dogma".equals(name)) {
                    builder.put(name, metadata);
                }
            });
            return new ProjectMetadata(projectMetadata.name(), (Map<String, RepositoryMetadata>)builder.build(), projectMetadata.members(), projectMetadata.tokens(), projectMetadata.creation(), projectMetadata.removal());
        }) : new RepositoryMetadataTransformer(newRepoName, (headRevision, repositoryMetadata) -> {
            MetadataService.throwIfRedundant(repositoryStatus, headRevision, repositoryMetadata, newRepoName);
            return new RepositoryMetadata(repositoryMetadata.name(), repositoryMetadata.roles(), repositoryMetadata.creation(), repositoryMetadata.removal(), repositoryStatus);
        });
        String commitSummary = "Update the status of '" + projectName + "/" + newRepoName + "'. status: " + String.valueOf(repositoryStatus);
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, transformer, true);
    }

    private static void throwIfRedundant(RepositoryStatus repositoryStatus, Revision headRevision, RepositoryMetadata repositoryMetadata, String newRepoName) {
        if (repositoryMetadata.status() == repositoryStatus) {
            throw new RedundantChangeException(headRevision, "the status of '" + newRepoName + "' isn't changed. status: " + String.valueOf(repositoryStatus));
        }
    }

    private static /* synthetic */ CompletableFuture lambda$getOrFetchMetadata$0(CompletableFuture future, String key) {
        return future;
    }
}

