/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.management;

import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.centraldogma.server.management.ServerStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class ServerStatusManager {
    private static final String STATUS = "status";
    private final Executor sequentialExecutor = Executors.newSingleThreadExecutor(ThreadFactories.newThreadFactory((String)"server-status-manager", (boolean)true));
    private final Path serverStatusFile;

    public ServerStatusManager(File dataDir) {
        Objects.requireNonNull(dataDir, "dataDir");
        File serverStatusFile = new File(dataDir, "server-status.properties");
        try {
            serverStatusFile.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create server status file: " + String.valueOf(serverStatusFile), e);
        }
        this.serverStatusFile = serverStatusFile.toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerStatus serverStatus() {
        Properties properties = new Properties();
        Path path = this.serverStatusFile;
        synchronized (path) {
            try {
                properties.load(Files.newInputStream(this.serverStatusFile, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load server status file: " + String.valueOf(this.serverStatusFile), e);
            }
        }
        String status = properties.getProperty(STATUS, "WRITABLE");
        return ServerStatus.valueOf(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(ServerStatus newServerStatus) {
        Path path = this.serverStatusFile;
        synchronized (path) {
            Properties properties = new Properties();
            try {
                properties.load(Files.newInputStream(this.serverStatusFile, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load server status file: " + String.valueOf(this.serverStatusFile), e);
            }
            properties.setProperty(STATUS, newServerStatus.name());
            try {
                properties.store(Files.newOutputStream(this.serverStatusFile, new OpenOption[0]), "Do not edit this file manually. Use the AdministrativeService API.");
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to store server status file: " + String.valueOf(this.serverStatusFile), e);
            }
        }
    }

    public Executor sequentialExecutor() {
        return this.sequentialExecutor;
    }
}

