/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.management;

import com.fasterxml.jackson.annotation.JsonProperty;

public enum ServerStatus {
    READ_ONLY(false, false),
    REPLICATION_ONLY(false, true),
    WRITABLE(true, true);

    private final boolean writable;
    private final boolean replicating;

    private ServerStatus(boolean writable, boolean replicating) {
        this.writable = writable;
        this.replicating = replicating;
    }

    public static ServerStatus of(boolean writable, boolean replicating) {
        if (writable) {
            if (replicating) {
                return WRITABLE;
            }
            throw new IllegalArgumentException("replicating must be true if writable is true");
        }
        if (replicating) {
            return REPLICATION_ONLY;
        }
        return READ_ONLY;
    }

    @JsonProperty(value="writable")
    public boolean writable() {
        return this.writable;
    }

    @JsonProperty(value="replicating")
    public boolean replicating() {
        return this.replicating;
    }
}

