/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbRepository;
import java.io.IOException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class RocksDbRefUpdate
extends RefUpdate {
    private final RefDatabase refDatabase;
    private final RocksDbRepository repo;

    RocksDbRefUpdate(Ref ref, RefDatabase refDatabase, RocksDbRepository repo) {
        super(ref);
        this.refDatabase = refDatabase;
        this.repo = repo;
    }

    protected RefDatabase getRefDatabase() {
        return this.refDatabase;
    }

    protected Repository getRepository() {
        return this.repo;
    }

    protected boolean tryLock(boolean deref) throws IOException {
        return true;
    }

    protected void unlock() {
    }

    protected RefUpdate.Result doUpdate(RefUpdate.Result desiredResult) throws IOException {
        return this.repo.encryptionGitStorage().updateRef(this.getRef().getName(), this.getNewObjectId(), desiredResult);
    }

    protected RefUpdate.Result doDelete(RefUpdate.Result desiredResult) throws IOException {
        if (this.getRef().getStorage() != Ref.Storage.NEW) {
            this.repo.encryptionGitStorage().deleteRef(this.getRef().getName());
        }
        return desiredResult;
    }

    protected RefUpdate.Result doLink(String target) throws IOException {
        assert (target.startsWith("refs/")) : target;
        this.repo.encryptionGitStorage().linkRef(this.getRef().getName(), target);
        if (this.getRef().getStorage() == Ref.Storage.NEW) {
            return RefUpdate.Result.NEW;
        }
        return RefUpdate.Result.FORCED;
    }
}

