/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.EncryptionGitStorage;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;

final class RocksDbObjectReader
extends ObjectReader {
    private final EncryptionGitStorage encryptionGitStorage;

    RocksDbObjectReader(EncryptionGitStorage encryptionGitStorage) {
        this.encryptionGitStorage = encryptionGitStorage;
    }

    public ObjectReader newReader() {
        return this;
    }

    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            ObjectLoader loader = this.encryptionGitStorage.getObject(id.toObjectId(), -1);
            if (loader != null) {
                return ImmutableList.of((Object)id.toObjectId());
            }
            return ImmutableList.of();
        }
        throw new UnsupportedOperationException("Resolving abbreviated object ID is not supported");
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws IOException {
        ObjectId toObjectId = objectId.toObjectId();
        ObjectLoader objectLoader = this.encryptionGitStorage.getObject(toObjectId, typeHint);
        if (objectLoader == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(toObjectId, JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(toObjectId, typeHint);
        }
        return objectLoader;
    }

    public Set<ObjectId> getShallowCommits() throws IOException {
        return ImmutableSet.of();
    }

    public void close() {
    }
}

