/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.common.Revision;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class Watch {
    private final Revision lastKnownRevision;
    @Nullable
    private final CompletableFuture<Revision> future;
    @Nullable
    private final WatchListener listener;
    private final boolean canRemove;
    private volatile boolean removed;

    Watch(Revision lastKnownRevision, @Nullable CompletableFuture<Revision> future, @Nullable WatchListener listener) {
        this.lastKnownRevision = lastKnownRevision;
        assert (future != null && listener == null || future == null && listener != null);
        this.future = future;
        this.listener = listener;
        this.canRemove = future != null;
    }

    void notify(Revision revision) {
        if (this.future != null) {
            this.future.complete(revision);
        } else {
            assert (this.listener != null);
            this.listener.onUpdate(revision, null);
        }
    }

    void notifyFailure(Throwable cause) {
        if (this.future != null) {
            this.future.completeExceptionally(cause);
        } else {
            assert (this.listener != null);
            this.listener.onUpdate(null, cause);
        }
    }

    Revision lastKnownRevision() {
        return this.lastKnownRevision;
    }

    @Nullable
    CompletableFuture<Revision> future() {
        return this.future;
    }

    boolean canRemove() {
        return this.canRemove;
    }

    void remove() {
        this.removed = true;
    }

    boolean wasRemoved() {
        return this.removed;
    }

    @FunctionalInterface
    static interface WatchListener {
        public void onUpdate(@Nullable Revision var1, @Nullable Throwable var2);
    }
}

