/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.internal.storage.repository.git.AbstractChangesApplier;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;

final class TransformingChangesApplier
extends AbstractChangesApplier {
    private final ContentTransformer<JsonNode> transformer;

    TransformingChangesApplier(ContentTransformer<?> transformer) {
        Preconditions.checkArgument((transformer.entryType() == EntryType.JSON ? 1 : 0) != 0, (String)"transformer: %s (expected: JSON type)", transformer);
        this.transformer = transformer;
    }

    @Override
    int doApply(Revision headRevision, DirCache dirCache, ObjectReader reader, ObjectInserter inserter) throws IOException {
        String changePath = this.transformer.path().substring(1);
        DirCacheEntry oldEntry = dirCache.getEntry(changePath);
        byte[] oldContent = oldEntry != null ? reader.open((AnyObjectId)oldEntry.getObjectId()).getBytes() : null;
        JsonNode oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : JsonNodeFactory.instance.nullNode();
        try {
            JsonNode newJsonNode = this.transformer.transformer().apply(headRevision, oldJsonNode.deepCopy());
            Objects.requireNonNull(newJsonNode, "transformer.transformer().apply() returned null");
            if (!Objects.equals(newJsonNode, oldJsonNode)) {
                TransformingChangesApplier.applyPathEdit(dirCache, new AbstractChangesApplier.InsertJson(changePath, inserter, newJsonNode));
                return 1;
            }
        }
        catch (CentralDogmaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ChangeConflictException("failed to transform the content: " + String.valueOf(oldJsonNode) + " transformer: " + String.valueOf(this.transformer), (Throwable)e);
        }
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transformer", this.transformer).toString();
    }
}

