/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceMode;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.internal.IsolatedSystemReader;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.AbstractChangesApplier;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CacheableCompareTreesCall;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitExecutor;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitIdDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitWatchers;
import com.linecorp.centraldogma.server.internal.storage.repository.git.DefaultChangesApplier;
import com.linecorp.centraldogma.server.internal.storage.repository.git.FailFastUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.PathPatternFilter;
import com.linecorp.centraldogma.server.internal.storage.repository.git.TransformingChangesApplier;
import com.linecorp.centraldogma.server.internal.storage.repository.git.Watch;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbRepository;
import com.linecorp.centraldogma.server.storage.StorageException;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.DiffResultType;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.RepositoryListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitRepository
implements com.linecorp.centraldogma.server.storage.repository.Repository {
    private static final Logger logger = LoggerFactory.getLogger(GitRepository.class);
    static final String R_HEADS_MASTER = "refs/heads/master";
    private static final Pattern CR = Pattern.compile("\r", 16);
    private static final Field revWalkObjectsField;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Project parent;
    private final Executor repositoryWorker;
    private final long creationTimeMillis;
    private final Author author;
    @Nullable
    @VisibleForTesting
    final RepositoryCache cache;
    private final File repoDir;
    private final String name;
    private final Repository jGitRepository;
    private final boolean isEncrypted;
    private final CommitIdDatabase commitIdDatabase;
    @VisibleForTesting
    final CommitWatchers commitWatchers = new CommitWatchers();
    private final AtomicReference<Supplier<CentralDogmaException>> closePending = new AtomicReference();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final List<RepositoryListener> listeners = new CopyOnWriteArrayList<RepositoryListener>();
    private volatile Revision headRevision;

    GitRepository(Project parent, File repoDir, Executor repositoryWorker, long creationTimeMillis, Author author, @Nullable RepositoryCache cache, Repository jGitRepository, CommitIdDatabase commitIdDatabase) {
        this.parent = parent;
        this.repoDir = repoDir;
        this.name = repoDir.getName();
        this.repositoryWorker = repositoryWorker;
        this.creationTimeMillis = creationTimeMillis;
        this.author = author;
        this.cache = cache;
        this.jGitRepository = jGitRepository;
        this.isEncrypted = jGitRepository instanceof RocksDbRepository;
        this.commitIdDatabase = commitIdDatabase;
        new CommitExecutor(this, creationTimeMillis, author, "Create a new repository", "", Markup.PLAINTEXT, true).executeInitialCommit();
        this.headRevision = Revision.INIT;
    }

    GitRepository(Project parent, File repoDir, Executor repositoryWorker, @Nullable RepositoryCache cache, Repository jGitRepository, CommitIdDatabase commitIdDatabase, Revision headRevision) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.repoDir = Objects.requireNonNull(repoDir, "repoDir");
        this.name = Objects.requireNonNull(repoDir, "repoDir").getName();
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.cache = cache;
        this.jGitRepository = Objects.requireNonNull(jGitRepository, "jGitRepository");
        this.isEncrypted = jGitRepository instanceof RocksDbRepository;
        this.commitIdDatabase = Objects.requireNonNull(commitIdDatabase, "commitIdDatabase");
        this.headRevision = Objects.requireNonNull(headRevision, "headRevision");
        Commit initialCommit = this.blockingHistory(Revision.INIT, Revision.INIT, "/**", 1).get(0);
        this.creationTimeMillis = initialCommit.when();
        this.author = initialCommit.author();
    }

    void close(Supplier<CentralDogmaException> failureCauseSupplier) {
        Objects.requireNonNull(failureCauseSupplier, "failureCauseSupplier");
        if (this.closePending.compareAndSet(null, failureCauseSupplier)) {
            this.repositoryWorker.execute(() -> {
                this.rwLock.writeLock().lock();
                try {
                    GitRepository.closeRepository(this.commitIdDatabase, this.jGitRepository);
                }
                finally {
                    try {
                        this.rwLock.writeLock().unlock();
                    }
                    finally {
                        this.commitWatchers.close(failureCauseSupplier);
                        this.closeFuture.complete(null);
                    }
                }
            });
        }
        this.closeFuture.join();
    }

    static void closeRepository(@Nullable CommitIdDatabase commitIdDatabase, @Nullable Repository jGitRepository) {
        if (commitIdDatabase != null) {
            try {
                commitIdDatabase.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close a commitId database:", (Throwable)e);
            }
        }
        if (jGitRepository != null) {
            try {
                jGitRepository.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close a Git repository: {}", (Object)jGitRepository.getDirectory(), (Object)e);
            }
        }
    }

    void internalClose() {
        this.close(() -> new CentralDogmaException("should never reach here"));
    }

    CommitIdDatabase commitIdDatabase() {
        return this.commitIdDatabase;
    }

    @Override
    public Repository jGitRepository() {
        return this.jGitRepository;
    }

    @Override
    public Project parent() {
        return this.parent;
    }

    @Override
    public File repoDir() {
        return this.repoDir;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long creationTimeMillis() {
        return this.creationTimeMillis;
    }

    @Override
    public Author author() {
        return this.author;
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return GitRepository.normalizeNow(revision, this.cachedHeadRevision().major());
    }

    private static Revision normalizeNow(Revision revision, int baseMajor) {
        Objects.requireNonNull(revision, "revision");
        int major = revision.major();
        if (major >= 0 ? major > baseMajor : (major = baseMajor + major + 1) <= 0) {
            throw new RevisionNotFoundException(revision);
        }
        if (revision.major() == major) {
            return revision;
        }
        return new Revision(major);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        int baseMajor = this.cachedHeadRevision().major();
        return new RevisionRange(GitRepository.normalizeNow(from, baseMajor), GitRepository.normalizeNow(to, baseMajor));
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "find", revision, pathPattern, options);
            return this.blockingFind(revision, pathPattern, options);
        }, this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Entry<?>> blockingFind(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "history", from, to, pathPattern, maxCommits);
            return this.blockingHistory(from, to, pathPattern, maxCommits);
        }, this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    List<Commit> blockingHistory(Revision from, Revision to, String pathPattern, int maxCommits) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Commit toCommit(RevCommit revCommit) {
        long when;
        Author author;
        PersonIdent committerIdent = revCommit.getCommitterIdent();
        if (committerIdent == null) {
            author = Author.UNKNOWN;
            when = 0L;
        } else {
            author = new Author(committerIdent.getName(), committerIdent.getEmailAddress());
            when = committerIdent.getWhen().getTime();
        }
        try {
            return CommitUtil.newCommit(author, when, revCommit.getFullMessage());
        }
        catch (Exception e) {
            throw new StorageException("failed to create a Commit", e);
        }
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern, DiffResultType diffResultType) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            Objects.requireNonNull(from, "from");
            Objects.requireNonNull(to, "to");
            Objects.requireNonNull(pathPattern, "pathPattern");
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "diff", from, to, pathPattern);
            RevisionRange range = this.normalizeNow(from, to).toAscending();
            this.readLock();
            try {
                Map<String, Change<?>> map;
                block12: {
                    RevWalk rw = this.newRevWalk();
                    try {
                        RevTree treeA = rw.parseTree((AnyObjectId)this.commitIdDatabase.get(range.from()));
                        RevTree treeB = rw.parseTree((AnyObjectId)this.commitIdDatabase.get(range.to()));
                        map = this.toChangeMap(this.blockingCompareTreesUncached(treeA, treeB, GitRepository.pathPatternFilterOrTreeFilter(pathPattern)), diffResultType);
                        if (rw == null) break block12;
                    }
                    catch (Throwable t$) {
                        try {
                            if (rw != null) {
                                try {
                                    rw.close();
                                }
                                catch (Throwable x2) {
                                    t$.addSuppressed(x2);
                                }
                            }
                            throw t$;
                        }
                        catch (StorageException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new StorageException("failed to parse two trees: range=" + String.valueOf(range), e);
                        }
                    }
                    rw.close();
                }
                return map;
            }
            finally {
                this.readUnlock();
            }
        }, this.repositoryWorker);
    }

    private static TreeFilter pathPatternFilterOrTreeFilter(@Nullable String pathPattern) {
        if (pathPattern == null) {
            return TreeFilter.ALL;
        }
        PathPatternFilter pathPatternFilter = PathPatternFilter.of(pathPattern);
        return pathPatternFilter.matchesAll() ? TreeFilter.ALL : pathPatternFilter;
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "previewDiff", baseRevision);
            return this.blockingPreviewDiff(baseRevision, new DefaultChangesApplier(changes));
        }, this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    Map<String, Change<?>> blockingPreviewDiff(Revision baseRevision, AbstractChangesApplier changesApplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Change<?>> toChangeMap(List<DiffEntry> diffEntryList, DiffResultType diffResultType) {
        LinkedHashMap<String, Change<?>> linkedHashMap;
        block26: {
            ObjectReader reader = this.jGitRepository.newObjectReader();
            try {
                LinkedHashMap changeMap = new LinkedHashMap();
                block20: for (DiffEntry diffEntry : diffEntryList) {
                    String oldPath = "/" + diffEntry.getOldPath();
                    String newPath = "/" + diffEntry.getNewPath();
                    switch (diffEntry.getChangeType()) {
                        case MODIFY: {
                            EntryType oldEntryType = EntryType.guessFromPath((String)oldPath);
                            switch (oldEntryType) {
                                case JSON: {
                                    JsonNode newJsonNode;
                                    JsonNode oldJsonNode;
                                    JsonPatch patch;
                                    if (!oldPath.equals(newPath)) {
                                        GitRepository.putChange(changeMap, oldPath, Change.ofRename((String)oldPath, (String)newPath));
                                    }
                                    if ((patch = JsonPatch.generate((JsonNode)(oldJsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getOldId().toObjectId()).getBytes())), (JsonNode)(newJsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes())), (ReplaceMode)ReplaceMode.SAFE)).isEmpty()) continue block20;
                                    if (diffResultType == DiffResultType.PATCH_TO_UPSERT) {
                                        GitRepository.putChange(changeMap, newPath, Change.ofJsonUpsert((String)newPath, (JsonNode)newJsonNode));
                                        continue block20;
                                    }
                                    GitRepository.putChange(changeMap, newPath, Change.ofJsonPatch((String)newPath, (JsonNode)Jackson.valueToTree((Object)patch)));
                                    continue block20;
                                }
                                case TEXT: {
                                    String oldText = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getOldId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                    String newText = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                    if (!oldPath.equals(newPath)) {
                                        GitRepository.putChange(changeMap, oldPath, Change.ofRename((String)oldPath, (String)newPath));
                                    }
                                    if (oldText.equals(newText)) continue block20;
                                    if (diffResultType == DiffResultType.PATCH_TO_UPSERT) {
                                        GitRepository.putChange(changeMap, newPath, Change.ofTextUpsert((String)newPath, (String)newText));
                                        continue block20;
                                    }
                                    GitRepository.putChange(changeMap, newPath, Change.ofTextPatch((String)newPath, (String)oldText, (String)newText));
                                    continue block20;
                                }
                            }
                            throw new Error("unexpected old entry type: " + String.valueOf(oldEntryType));
                        }
                        case ADD: {
                            EntryType newEntryType = EntryType.guessFromPath((String)newPath);
                            switch (newEntryType) {
                                case JSON: {
                                    JsonNode jsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes());
                                    GitRepository.putChange(changeMap, newPath, Change.ofJsonUpsert((String)newPath, (JsonNode)jsonNode));
                                    continue block20;
                                }
                                case TEXT: {
                                    String text = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                    GitRepository.putChange(changeMap, newPath, Change.ofTextUpsert((String)newPath, (String)text));
                                    continue block20;
                                }
                            }
                            throw new Error("unexpected new entry type: " + String.valueOf(newEntryType));
                        }
                        case DELETE: {
                            GitRepository.putChange(changeMap, oldPath, Change.ofRemoval((String)oldPath));
                            continue block20;
                        }
                    }
                    throw new Error();
                }
                linkedHashMap = changeMap;
                if (reader == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException("failed to convert list of DiffEntry to Changes map", e);
                }
            }
            reader.close();
        }
        return linkedHashMap;
    }

    private static void putChange(Map<String, Change<?>> changeMap, String path, Change<?> change) {
        Change<?> oldChange = changeMap.put(path, change);
        assert (oldChange == null);
    }

    @Override
    public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean directExecution) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(summary, "summary");
        Objects.requireNonNull(detail, "detail");
        Objects.requireNonNull(markup, "markup");
        Objects.requireNonNull(changes, "changes");
        CommitExecutor commitExecutor = new CommitExecutor(this, commitTimeMillis, author, summary, detail, markup, false);
        return this.commit(baseRevision, commitExecutor, normBaseRevision -> {
            if (!directExecution) {
                return changes;
            }
            return this.blockingPreviewDiff((Revision)normBaseRevision, new DefaultChangesApplier(changes)).values();
        });
    }

    @Override
    public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, ContentTransformer<?> transformer) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(summary, "summary");
        Objects.requireNonNull(detail, "detail");
        Objects.requireNonNull(markup, "markup");
        Objects.requireNonNull(transformer, "transformer");
        CommitExecutor commitExecutor = new CommitExecutor(this, commitTimeMillis, author, summary, detail, markup, false);
        return this.commit(baseRevision, commitExecutor, normBaseRevision -> this.blockingPreviewDiff((Revision)normBaseRevision, new TransformingChangesApplier(transformer)).values());
    }

    private CompletableFuture<CommitResult> commit(Revision baseRevision, CommitExecutor commitExecutor, Function<Revision, Iterable<Change<?>>> applyingChangesProvider) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "commit", baseRevision, commitExecutor.author(), commitExecutor.summary());
            return commitExecutor.execute(baseRevision, applyingChangesProvider);
        }, this.repositoryWorker);
    }

    static String sanitizeText(String text) {
        if (((String)text).indexOf(13) >= 0) {
            text = CR.matcher((CharSequence)text).replaceAll("");
        }
        if (!((String)text).isEmpty() && !((String)text).endsWith("\n")) {
            text = (String)text + "\n";
        }
        return text;
    }

    static void doRefUpdate(Repository jGitRepository, RevWalk revWalk, String ref, ObjectId commitId) throws IOException {
        if (ref.startsWith("refs/tags/")) {
            throw new StorageException("Using a tag is not allowed. ref: " + ref);
        }
        RefUpdate refUpdate = jGitRepository.updateRef(ref);
        refUpdate.setNewObjectId((AnyObjectId)commitId);
        RefUpdate.Result res = refUpdate.update(revWalk);
        switch (res) {
            case NEW: 
            case FAST_FORWARD: {
                break;
            }
            default: {
                throw new StorageException("unexpected refUpdate state: " + String.valueOf(res));
            }
        }
    }

    @Override
    public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "findLatestRevision", lastKnownRevision, pathPattern);
            return this.blockingFindLatestRevision(lastKnownRevision, pathPattern, errorOnEntryNotFound);
        }, this.repositoryWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Revision blockingFindLatestRevision(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        List<DiffEntry> diffEntries;
        RevisionRange range = this.normalizeNow(lastKnownRevision, Revision.HEAD);
        if (range.from().equals((Object)range.to())) {
            if (!errorOnEntryNotFound) {
                return null;
            }
            Map<String, Entry<?>> entries = this.blockingFind(range.to(), pathPattern, FindOptions.FIND_ONE_WITHOUT_CONTENT);
            if (!entries.isEmpty()) {
                return null;
            }
            throw new EntryNotFoundException(lastKnownRevision, pathPattern);
        }
        if (range.from().major() == 1) {
            Map<String, Entry<?>> entries = this.blockingFind(range.to(), pathPattern, FindOptions.FIND_ONE_WITHOUT_CONTENT);
            if (entries.isEmpty()) {
                if (!errorOnEntryNotFound) {
                    return null;
                }
                throw new EntryNotFoundException(lastKnownRevision, pathPattern);
            }
            return range.to();
        }
        PathPatternFilter filter = PathPatternFilter.of(pathPattern);
        this.readLock();
        try (RevWalk revWalk = this.newRevWalk();){
            RevTree treeA = this.toTree(revWalk, range.from());
            RevTree treeB = this.toTree(revWalk, range.to());
            diffEntries = this.blockingCompareTrees(treeA, treeB);
        }
        finally {
            this.readUnlock();
        }
        for (DiffEntry e : diffEntries) {
            String path;
            switch (e.getChangeType()) {
                case ADD: {
                    path = e.getNewPath();
                    break;
                }
                case MODIFY: 
                case DELETE: {
                    path = e.getOldPath();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (!filter.matches(path)) continue;
            return range.to();
        }
        if (!errorOnEntryNotFound) {
            return null;
        }
        if (!this.blockingFind(range.to(), pathPattern, FindOptions.FIND_ONE_WITHOUT_CONTENT).isEmpty()) {
            return null;
        }
        throw new EntryNotFoundException(lastKnownRevision, pathPattern);
    }

    private List<DiffEntry> blockingCompareTrees(RevTree treeA, RevTree treeB) {
        if (this.cache == null) {
            return this.blockingCompareTreesUncached(treeA, treeB, TreeFilter.ALL);
        }
        CacheableCompareTreesCall key = new CacheableCompareTreesCall(this, treeA, treeB);
        return this.cache.get(key).join();
    }

    List<DiffEntry> blockingCompareTreesUncached(@Nullable RevTree treeA, @Nullable RevTree treeB, TreeFilter filter) {
        this.readLock();
        try {
            ImmutableList immutableList;
            DiffFormatter diffFormatter = new DiffFormatter(null);
            try {
                diffFormatter.setRepository(this.jGitRepository);
                diffFormatter.setPathFilter(filter);
                immutableList = ImmutableList.copyOf((Collection)diffFormatter.scan(treeA, treeB));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        diffFormatter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException("failed to compare two trees: " + String.valueOf(treeA) + " vs. " + String.valueOf(treeB), e);
                }
            }
            diffFormatter.close();
            return immutableList;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        ServiceRequestContext ctx = FailFastUtil.context();
        Revision normLastKnownRevision = this.normalizeNow(lastKnownRevision);
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        CompletableFuture.runAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "watch", lastKnownRevision, pathPattern);
            this.readLock();
            try {
                Revision latestRevision = this.blockingFindLatestRevision(normLastKnownRevision, pathPattern, errorOnEntryNotFound);
                if (latestRevision != null) {
                    future.complete(latestRevision);
                } else {
                    this.commitWatchers.add(normLastKnownRevision, pathPattern, future, null);
                }
            }
            finally {
                this.readUnlock();
            }
        }, this.repositoryWorker).exceptionally(cause -> {
            future.completeExceptionally((Throwable)cause);
            return null;
        });
        return future;
    }

    private void recursiveWatch(String pathPattern, Watch.WatchListener listener) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        CompletableFuture.runAsync(() -> {
            Revision headRevision = this.headRevision;
            this.commitWatchers.add(headRevision, pathPattern, null, listener);
            listener.onUpdate(headRevision, null);
        }, this.repositoryWorker);
    }

    @Override
    public <T> CompletableFuture<T> execute(CacheableCall<T> cacheableCall) {
        Objects.requireNonNull(cacheableCall, "cacheableCall");
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "execute", cacheableCall);
            return cacheableCall.execute();
        }, this.repositoryWorker).thenCompose(Function.identity());
    }

    @Override
    public void addListener(RepositoryListener listener) {
        this.listeners.add(listener);
        String pathPattern = listener.pathPattern();
        this.recursiveWatch(pathPattern, (newRevision, cause) -> {
            if (this.shouldStopListening()) {
                return;
            }
            if (cause != null) {
                if ((cause = Exceptions.peel((Throwable)cause)) instanceof ShuttingDownException) {
                    return;
                }
                logger.warn("Failed to watch {} file in {}/{}.", new Object[]{pathPattern, this.parent.name(), this.name, cause});
                return;
            }
            try {
                assert (newRevision != null);
                listener.onUpdate(this.blockingFind(this.headRevision, pathPattern, (Map<FindOption<?>, ?>)ImmutableMap.of()));
            }
            catch (Exception ex) {
                logger.warn("Unexpected exception while invoking {}.onUpdate(). listener: {}", new Object[]{RepositoryListener.class.getSimpleName(), listener, ex});
            }
        });
    }

    private boolean shouldStopListening() {
        return this.closePending.get() != null;
    }

    void notifyWatchers(Revision newRevision, List<DiffEntry> diffEntries) {
        block4: for (DiffEntry entry : diffEntries) {
            switch (entry.getChangeType()) {
                case ADD: {
                    this.commitWatchers.notify(newRevision, entry.getNewPath());
                    continue block4;
                }
                case MODIFY: 
                case DELETE: {
                    this.commitWatchers.notify(newRevision, entry.getOldPath());
                    continue block4;
                }
            }
            throw new Error();
        }
    }

    Revision cachedHeadRevision() {
        return this.headRevision;
    }

    void setHeadRevision(Revision headRevision) {
        this.headRevision = headRevision;
    }

    private RevTree toTree(RevWalk revWalk, Revision revision) {
        return GitRepository.toTree(this.commitIdDatabase, revWalk, revision);
    }

    static RevTree toTree(CommitIdDatabase commitIdDatabase, RevWalk revWalk, Revision revision) {
        ObjectId commitId = commitIdDatabase.get(revision);
        try {
            return revWalk.parseCommit((AnyObjectId)commitId).getTree();
        }
        catch (IOException e) {
            throw new StorageException("failed to parse a commit: " + String.valueOf(commitId), e);
        }
    }

    private RevWalk newRevWalk() {
        RevWalk revWalk = new RevWalk(this.jGitRepository);
        GitRepository.configureRevWalk(revWalk);
        return revWalk;
    }

    static RevWalk newRevWalk(ObjectReader reader) {
        RevWalk revWalk = new RevWalk(reader);
        GitRepository.configureRevWalk(revWalk);
        return revWalk;
    }

    private static void configureRevWalk(RevWalk revWalk) {
        revWalk.setRewriteParents(false);
    }

    private void readLock() {
        this.rwLock.readLock().lock();
        if (this.closePending.get() != null) {
            this.rwLock.readLock().unlock();
            throw this.closePending.get().get();
        }
    }

    private void readUnlock() {
        this.rwLock.readLock().unlock();
    }

    void writeLock() {
        this.rwLock.writeLock().lock();
        if (this.closePending.get() != null) {
            this.writeUnLock();
            throw this.closePending.get().get();
        }
    }

    void writeUnLock() {
        this.rwLock.writeLock().unlock();
    }

    static void deleteCruft(File repoDir) {
        try {
            Util.deleteFileTree((File)repoDir);
        }
        catch (IOException e) {
            logger.error("Failed to delete a half-created repository at: {}", (Object)repoDir, (Object)e);
        }
    }

    @Override
    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dir", (Object)this.jGitRepository.getDirectory()).toString();
    }

    static {
        String jgitPomProperties = "META-INF/maven/org.eclipse.jgit/org.eclipse.jgit/pom.properties";
        try (InputStream is = SystemReader.class.getClassLoader().getResourceAsStream("META-INF/maven/org.eclipse.jgit/org.eclipse.jgit/pom.properties");){
            Properties props = new Properties();
            props.load(is);
            Object jgitVersion = props.get("version");
            if (jgitVersion != null) {
                logger.info("Using JGit: {}", jgitVersion);
            }
        }
        catch (IOException e) {
            logger.debug("Failed to read JGit version", (Throwable)e);
        }
        IsolatedSystemReader.install();
        Field field = null;
        try {
            field = RevWalk.class.getDeclaredField("objects");
            if (field.getType() != ObjectIdOwnerMap.class) {
                throw new IllegalStateException(RevWalk.class.getSimpleName() + ".objects is not an " + ObjectIdOwnerMap.class.getSimpleName() + ".");
            }
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(RevWalk.class.getSimpleName() + ".objects does not exist.");
        }
        revWalkObjectsField = field;
    }
}

