/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.storage.repository.CrudRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.HasRevision;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class GitCrudRepository<T>
implements CrudRepository<T> {
    private final CommandExecutor executor;
    private final Repository repository;
    private final Class<T> entityType;
    private final String projectName;
    private final String repoName;
    private final String targetPath;

    public GitCrudRepository(Class<T> entityType, CommandExecutor executor, ProjectManager projectManager, String projectName, String repoName, String targetPath) {
        this.executor = executor;
        this.repository = (Repository)((Project)projectManager.get(projectName)).repos().get(repoName);
        this.entityType = entityType;
        this.projectName = projectName;
        this.repoName = repoName;
        Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"targetPath: %s (expected: starts with '/')", (Object)targetPath);
        Preconditions.checkArgument((boolean)targetPath.endsWith("/"), (String)"targetPath: %s (expected: ends with '/')", (Object)targetPath);
        this.targetPath = targetPath;
    }

    @Override
    public CompletableFuture<HasRevision<T>> save(String id, T entity, Author author, String description) {
        String path = this.getPath(id);
        Change change = Change.ofJsonUpsert((String)path, (JsonNode)Jackson.valueToTree(entity));
        Command<CommitResult> command = Command.push(author, this.projectName, this.repoName, Revision.HEAD, description, "", Markup.MARKDOWN, change);
        return this.executor.execute(command).thenCompose(result -> this.repository.get(result.revision(), path).thenApply(this::entryToValue));
    }

    @Override
    public CompletableFuture<HasRevision<T>> find(String id) {
        String path = this.getPath(id);
        return this.repository.getOrNull(Revision.HEAD, path).thenApply(this::entryToValue);
    }

    @Override
    public CompletableFuture<List<HasRevision<T>>> findAll() {
        return this.repository.find(Revision.HEAD, this.targetPath + "*.json").thenApply(entries -> (List)entries.values().stream().map(this::entryToValue).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public CompletableFuture<Revision> delete(String id, Author author, String description) {
        String path = this.getPath(id);
        Change change = Change.ofRemoval((String)path);
        Command<CommitResult> command = Command.push(Author.SYSTEM, this.projectName, this.repoName, Revision.HEAD, description, "", Markup.MARKDOWN, change);
        return this.executor.execute(command).thenApply(CommitResult::revision);
    }

    private HasRevision<T> entryToValue(@Nullable Entry<?> entry) {
        if (entry == null) {
            return null;
        }
        try {
            return HasRevision.of(Jackson.treeToValue((TreeNode)entry.contentAsJson(), this.entityType), entry.revision());
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPath(String id) {
        GitCrudRepository.validateId(id);
        return this.targetPath + id + ".json";
    }

    public static String validateId(String id) {
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id is empty.");
        return Util.validateFileName((String)id, (String)"id");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityType", this.entityType).add("executor", (Object)this.executor).add("repository", (Object)this.repository).add("projectName", (Object)this.projectName).add("repoName", (Object)this.repoName).add("targetPath", (Object)this.targetPath).toString();
    }
}

