/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.TextPatchConflictException;
import com.linecorp.centraldogma.common.jsonpatch.JsonPatchConflictException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.shaded.difflib.DiffUtils;
import com.linecorp.centraldogma.internal.shaded.difflib.Patch;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.git.AbstractChangesApplier;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;

final class DefaultChangesApplier
extends AbstractChangesApplier {
    private final Iterable<Change<?>> changes;

    DefaultChangesApplier(Iterable<Change<?>> changes) {
        this.changes = changes;
    }

    @Override
    int doApply(Revision unused, DirCache dirCache, ObjectReader reader, ObjectInserter inserter) throws IOException {
        int numEdits = 0;
        for (Change<?> change : this.changes) {
            String changePath = change.path().substring(1);
            DirCacheEntry oldEntry = dirCache.getEntry(changePath);
            byte[] oldContent = oldEntry != null ? reader.open((AnyObjectId)oldEntry.getObjectId()).getBytes() : null;
            switch (change.type()) {
                case UPSERT_JSON: {
                    Object oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : null;
                    JsonNode newJsonNode = (JsonNode)MoreObjects.firstNonNull((Object)((JsonNode)change.content()), (Object)JsonNodeFactory.instance.nullNode());
                    if (Objects.equals(newJsonNode, oldJsonNode)) break;
                    DefaultChangesApplier.applyPathEdit(dirCache, new AbstractChangesApplier.InsertJson(changePath, inserter, newJsonNode));
                    ++numEdits;
                    break;
                }
                case UPSERT_TEXT: {
                    String sanitizedOldText = oldContent != null ? GitRepository.sanitizeText(new String(oldContent, StandardCharsets.UTF_8)) : null;
                    String sanitizedNewText = GitRepository.sanitizeText(change.contentAsText());
                    if (sanitizedNewText.equals(sanitizedOldText)) break;
                    DefaultChangesApplier.applyPathEdit(dirCache, new AbstractChangesApplier.InsertText(changePath, inserter, sanitizedNewText));
                    ++numEdits;
                    break;
                }
                case REMOVE: {
                    if (oldEntry != null) {
                        DefaultChangesApplier.applyPathEdit(dirCache, (DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(changePath));
                        ++numEdits;
                        break;
                    }
                    if (DefaultChangesApplier.applyDirectoryEdits(dirCache, changePath, null, change)) {
                        ++numEdits;
                        break;
                    }
                    DefaultChangesApplier.reportNonExistentEntry(change);
                    break;
                }
                case RENAME: {
                    String newPath = ((String)change.content()).substring(1);
                    if (dirCache.getEntry(newPath) != null) {
                        throw new ChangeConflictException("a file exists at the target path: " + String.valueOf(change));
                    }
                    if (oldEntry != null) {
                        if (changePath.equals(newPath)) break;
                        DirCacheEditor editor = dirCache.editor();
                        editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(changePath));
                        editor.add((DirCacheEditor.PathEdit)new AbstractChangesApplier.CopyOldEntry(newPath, oldEntry));
                        editor.finish();
                        ++numEdits;
                        break;
                    }
                    if (DefaultChangesApplier.applyDirectoryEdits(dirCache, changePath, newPath, change)) {
                        ++numEdits;
                        break;
                    }
                    DefaultChangesApplier.reportNonExistentEntry(change);
                    break;
                }
                case APPLY_JSON_PATCH: {
                    JsonNode newJsonNode;
                    Object oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : Jackson.nullNode;
                    try {
                        newJsonNode = JsonPatch.fromJson((JsonNode)((JsonNode)change.content())).apply(oldJsonNode);
                    }
                    catch (JsonPatchConflictException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new JsonPatchConflictException("failed to apply JSON patch: " + String.valueOf(change), (Throwable)e);
                    }
                    if (newJsonNode.equals(oldJsonNode)) break;
                    DefaultChangesApplier.applyPathEdit(dirCache, new AbstractChangesApplier.InsertJson(changePath, inserter, newJsonNode));
                    ++numEdits;
                    break;
                }
                case APPLY_TEXT_PATCH: {
                    String newText;
                    List sanitizedOldTextLines;
                    String sanitizedOldText;
                    Patch patch = DiffUtils.parseUnifiedDiff((List)Util.stringToLines((String)GitRepository.sanitizeText((String)change.content())));
                    if (oldContent != null) {
                        sanitizedOldText = GitRepository.sanitizeText(new String(oldContent, StandardCharsets.UTF_8));
                        sanitizedOldTextLines = Util.stringToLines((String)sanitizedOldText);
                    } else {
                        sanitizedOldText = null;
                        sanitizedOldTextLines = Collections.emptyList();
                    }
                    try {
                        List newTextLines = DiffUtils.patch(sanitizedOldTextLines, (Patch)patch);
                        if (newTextLines.isEmpty()) {
                            newText = "";
                        } else {
                            StringJoiner joiner = new StringJoiner("\n", "", "\n");
                            for (String line : newTextLines) {
                                joiner.add(line);
                            }
                            newText = joiner.toString();
                        }
                    }
                    catch (Exception e) {
                        String message = "failed to apply text patch: " + String.valueOf(change);
                        if (e.getMessage() != null) {
                            message = message + " (reason: " + e.getMessage() + ")";
                        }
                        throw new TextPatchConflictException(message, (Throwable)e);
                    }
                    if (newText.equals(sanitizedOldText)) break;
                    DefaultChangesApplier.applyPathEdit(dirCache, new AbstractChangesApplier.InsertText(changePath, inserter, newText));
                    ++numEdits;
                }
            }
        }
        return numEdits;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changes", this.changes).toString();
    }

    private static boolean applyDirectoryEdits(DirCache dirCache, String oldDir, @Nullable String newDir, Change<?> change) {
        if (!((String)oldDir).endsWith("/")) {
            oldDir = (String)oldDir + "/";
        }
        if (newDir != null && !((String)newDir).endsWith("/")) {
            newDir = (String)newDir + "/";
        }
        byte[] rawOldDir = Constants.encode((String)oldDir);
        byte[] rawNewDir = newDir != null ? Constants.encode((String)newDir) : null;
        int numEntries = dirCache.getEntryCount();
        DirCacheEditor editor = null;
        block0: for (int i = 0; i < numEntries; ++i) {
            DirCacheEntry e = dirCache.getEntry(i);
            byte[] rawPath = e.getRawPath();
            if (rawNewDir != null) {
                boolean conflict = true;
                if (rawPath.length > rawNewDir.length) {
                    for (int j = 0; j < rawNewDir.length; ++j) {
                        if (rawNewDir[j] == rawPath[j]) continue;
                        conflict = false;
                        break;
                    }
                } else if (rawPath.length == rawNewDir.length - 1) {
                    for (int j = 0; j < rawNewDir.length - 1; ++j) {
                        if (rawNewDir[j] == rawPath[j]) continue;
                        conflict = false;
                        break;
                    }
                } else {
                    conflict = false;
                }
                if (conflict) {
                    throw new ChangeConflictException("target directory exists already: " + String.valueOf(change));
                }
            }
            if (rawPath.length <= rawOldDir.length) continue;
            for (int j = 0; j < rawOldDir.length; ++j) {
                if (rawOldDir[j] != rawPath[j]) continue block0;
            }
            if (editor == null) {
                editor = dirCache.editor();
                editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree((String)oldDir));
                if (newDir == null) break;
            }
            assert (newDir != null);
            String oldPath = e.getPathString();
            String newPath = (String)newDir + oldPath.substring(((String)oldDir).length());
            editor.add((DirCacheEditor.PathEdit)new AbstractChangesApplier.CopyOldEntry(newPath, e));
        }
        if (editor != null) {
            editor.finish();
            return true;
        }
        return false;
    }

    private static void reportNonExistentEntry(Change<?> change) {
        throw new ChangeConflictException("non-existent file/directory: " + String.valueOf(change));
    }
}

