/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.eclipse.jgit.diff.DiffEntry;

final class CommitExecutor {
    final GitRepository gitRepository;
    private final long commitTimeMillis;
    private final Author author;
    private final String summary;
    private final String detail;
    private final Markup markup;
    private final boolean allowEmptyCommit;

    CommitExecutor(GitRepository gitRepository, long commitTimeMillis, Author author, String summary, String detail, Markup markup, boolean allowEmptyCommit) {
        this.gitRepository = gitRepository;
        this.commitTimeMillis = commitTimeMillis;
        this.author = author;
        this.summary = summary;
        this.detail = detail;
        this.markup = markup;
        this.allowEmptyCommit = allowEmptyCommit;
    }

    Author author() {
        return this.author;
    }

    String summary() {
        return this.summary;
    }

    void executeInitialCommit() {
        this.commit(null, Revision.INIT, (Iterable<Change<?>>)ImmutableList.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommitResult execute(Revision baseRevision, Function<Revision, Iterable<Change<?>>> applyingChangesProvider) {
        RevisionAndEntries res;
        Iterable<Change<?>> applyingChanges;
        this.gitRepository.writeLock();
        try {
            Revision normBaseRevision = this.gitRepository.normalizeNow(baseRevision);
            Revision headRevision = this.gitRepository.cachedHeadRevision();
            if (headRevision.major() != normBaseRevision.major()) {
                throw new ChangeConflictException("invalid baseRevision: " + String.valueOf(baseRevision) + " (expected: " + String.valueOf(headRevision) + " or equivalent)");
            }
            applyingChanges = applyingChangesProvider.apply(normBaseRevision);
            res = this.commit(headRevision, headRevision.forward(1), applyingChanges);
            this.gitRepository.setHeadRevision(res.revision);
        }
        finally {
            this.gitRepository.writeUnLock();
        }
        this.gitRepository.notifyWatchers(res.revision, res.diffEntries);
        return CommitResult.of(res.revision, applyingChanges);
    }

    /*
     * Exception decompiling
     */
    RevisionAndEntries commit(@Nullable Revision headRevision, Revision nextRevision, Iterable<Change<?>> changes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final class RevisionAndEntries {
        final Revision revision;
        final List<DiffEntry> diffEntries;

        RevisionAndEntries(Revision revision, List<DiffEntry> diffEntries) {
            this.revision = revision;
            this.diffEntries = diffEntries;
        }
    }
}

