/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.primitives.Ints;
import com.linecorp.centraldogma.server.storage.repository.AbstractCacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;

final class CacheableObjectLoaderCall
extends AbstractCacheableCall<ObjectLoader> {
    private final ObjectReader delegate;
    private final AnyObjectId objectId;
    private final int hashCode;

    CacheableObjectLoaderCall(Repository repo, ObjectReader delegate, AnyObjectId objectId) {
        super(repo);
        this.delegate = delegate;
        this.objectId = objectId;
        this.hashCode = objectId.hashCode() * 31 + System.identityHashCode(repo);
    }

    @Override
    public int weigh(ObjectLoader value) {
        return Ints.saturatedCast((long)value.getSize());
    }

    @Override
    public CompletableFuture<ObjectLoader> execute() {
        try {
            return CompletableFuture.completedFuture(this.delegate.open(this.objectId, 2));
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to open an object: " + String.valueOf(this.objectId), e);
        }
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableObjectLoaderCall that = (CacheableObjectLoaderCall)o;
        return this.objectId.equals(that.objectId);
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("objectId", (Object)this.objectId);
    }
}

