/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import com.linecorp.centraldogma.server.storage.repository.AbstractCacheableCall;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

final class CacheableCompareTreesCall
extends AbstractCacheableCall<List<DiffEntry>> {
    private static final int SHA1_LEN = 20;
    private final GitRepository repo;
    @Nullable
    private final RevTree treeA;
    @Nullable
    private final RevTree treeB;
    private final int hashCode;

    CacheableCompareTreesCall(GitRepository repo, @Nullable RevTree treeA, @Nullable RevTree treeB) {
        super(repo);
        this.repo = repo;
        this.treeA = treeA;
        this.treeB = treeB;
        this.hashCode = Objects.hash(treeA, treeB) * 31 + System.identityHashCode(repo);
    }

    @Override
    public int weigh(List<DiffEntry> value) {
        int weight = 40;
        for (DiffEntry e : value) {
            Attribute attr;
            if (e.getOldId() != null) {
                weight += 20;
            }
            if (e.getNewId() != null) {
                weight += 20;
            }
            if (e.getOldPath() != null) {
                weight += e.getOldPath().length();
            }
            if (e.getNewPath() != null) {
                weight += e.getNewPath().length();
            }
            if ((attr = e.getDiffAttribute()) == null) continue;
            if (attr.getKey() != null) {
                weight += attr.getKey().length();
            }
            if (attr.getValue() == null) continue;
            weight += attr.getValue().length();
        }
        return weight;
    }

    @Override
    public CompletableFuture<List<DiffEntry>> execute() {
        RepositoryCache.logger.debug("Cache miss: {}", (Object)this);
        List<DiffEntry> diffEntries = this.repo.blockingCompareTreesUncached(this.treeA, this.treeB, TreeFilter.ALL);
        return CompletableFuture.completedFuture(diffEntries);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableCompareTreesCall that = (CacheableCompareTreesCall)o;
        return Objects.equals(this.treeA, that.treeA) && Objects.equals(this.treeB, that.treeB);
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("treeA", this.treeA != null ? this.treeA.getName() : null).add("treeB", this.treeB != null ? this.treeB.getName() : null);
    }
}

