/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.mirror.MirrorUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RepositoryUri {
    private final URI uri;
    private final String path;
    private final String branch;

    public static RepositoryUri parse(URI remoteUri, String suffix) {
        String remotePath;
        String host = remoteUri.getHost();
        if (host == null && !remoteUri.getScheme().endsWith("+file")) {
            throw new IllegalArgumentException("no host in remoteUri: " + String.valueOf(remoteUri));
        }
        String path = remoteUri.getRawPath();
        if (path == null) {
            throw new IllegalArgumentException("no path in remoteUri: " + String.valueOf(remoteUri));
        }
        Matcher matcher = Pattern.compile("^(.*?\\." + suffix + ")(?:$|/)").matcher(path);
        if (!matcher.find()) {
            throw new IllegalArgumentException("no '." + suffix + "' in remoteUri path: " + String.valueOf(remoteUri));
        }
        int port = remoteUri.getPort();
        String newRemoteUri = host != null ? (port > 0 ? remoteUri.getScheme() + "://" + host + ":" + port + matcher.group(1) : remoteUri.getScheme() + "://" + host + matcher.group(1)) : remoteUri.getScheme() + "://" + matcher.group(1);
        try {
            String decoded = URLDecoder.decode(path.substring(matcher.group(1).length()), "UTF-8");
            remotePath = decoded = MirrorUtil.normalizePath(decoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        String remoteBranch = remoteUri.getFragment();
        return new RepositoryUri(URI.create(newRemoteUri), remotePath, (String)MoreObjects.firstNonNull((Object)remoteBranch, (Object)""));
    }

    private RepositoryUri(URI uri, String path, String branch) {
        this.uri = uri;
        this.path = path;
        this.branch = branch;
    }

    public URI uri() {
        return this.uri;
    }

    public String path() {
        return this.path;
    }

    public String branch() {
        return this.branch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryUri)) {
            return false;
        }
        RepositoryUri that = (RepositoryUri)o;
        return this.uri.equals(that.uri) && this.path.equals(that.path) && this.branch.equals(that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.path, this.branch);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("path", (Object)this.path).add("branch", (Object)this.branch).toString();
    }
}

