/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.internal.api.v1.MirrorRequest;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorConfig;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorContext;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.mirror.MirrorProvider;
import com.linecorp.centraldogma.server.mirror.MirrorUtil;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.net.URI;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MirrorConverter {
    private static final Logger logger = LoggerFactory.getLogger(MirrorConverter.class);
    public static final List<MirrorProvider> MIRROR_PROVIDERS = ImmutableList.copyOf(ServiceLoader.load(MirrorProvider.class));

    @Nullable
    static Mirror convertToMirror(MirrorConfig mirrorConfig, Project parent, List<Credential> credentials) {
        if (!parent.repos().exists(mirrorConfig.localRepo())) {
            return null;
        }
        Credential credential = MirrorConverter.findCredential(mirrorConfig, credentials);
        return MirrorConverter.convertToMirror(mirrorConfig, parent, credential);
    }

    static Mirror convertToMirror(MirrorConfig mirrorConfig, Project parent, Credential credential) {
        MirrorContext mirrorContext = new MirrorContext(mirrorConfig.id(), mirrorConfig.enabled(), mirrorConfig.cronSchedule(), mirrorConfig.direction(), credential, (Repository)parent.repos().get(mirrorConfig.localRepo()), mirrorConfig.localPath(), mirrorConfig.rawRemoteUri(), mirrorConfig.gitignore(), mirrorConfig.zone());
        for (MirrorProvider mirrorProvider : MIRROR_PROVIDERS) {
            Mirror mirror = mirrorProvider.newMirror(mirrorContext);
            if (mirror == null) continue;
            return mirror;
        }
        throw new IllegalArgumentException("could not find a mirror provider for " + String.valueOf(mirrorContext));
    }

    private static Credential findCredential(MirrorConfig mirrorConfig, List<Credential> credentials) {
        for (Credential c : credentials) {
            if (!mirrorConfig.credentialName().equals(c.name())) continue;
            return c;
        }
        return Credential.NONE;
    }

    public static MirrorConfig converterToMirrorConfig(MirrorRequest mirrorRequest) {
        String remoteUri = mirrorRequest.remoteScheme() + "://" + mirrorRequest.remoteUrl() + MirrorUtil.normalizePath(mirrorRequest.remotePath()) + "#" + mirrorRequest.remoteBranch();
        return new MirrorConfig(mirrorRequest.id(), mirrorRequest.enabled(), mirrorRequest.schedule(), MirrorDirection.valueOf(mirrorRequest.direction()), mirrorRequest.localRepo(), mirrorRequest.localPath(), URI.create(remoteUri), mirrorRequest.gitignore(), null, mirrorRequest.credentialName(), mirrorRequest.zone());
    }

    private MirrorConverter() {
    }

    static {
        logger.debug("Available {}s: {}", (Object)MirrorProvider.class.getSimpleName(), MIRROR_PROVIDERS);
    }
}

